/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.web.interceptor.handler.impl;

import cn.com.duiba.sso.api.exception.SsoException;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.sso.api.web.interceptor.annotation.AuthCanAccess;
import cn.com.duiba.sso.api.web.interceptor.annotation.MobileHandler;
import cn.com.duiba.sso.api.web.interceptor.handler.SsoFilterHandler;
import cn.com.duiba.sso.api.web.power.AdminPowerCacheService;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Objects;
import java.io.IOException;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;

@MobileHandler
@Component
public class AuthorityFilterHandler
implements SsoFilterHandler {
    @Autowired
    private AdminPowerCacheService adminPowerCacheService;

    public int getOrder() {
        return 10;
    }

    @Override
    public Boolean before(Object handler) throws SsoException {
        HandlerMethod method;
        AuthCanAccess canAccess;
        if (handler instanceof HandlerMethod && !Objects.equal(null, (Object)(canAccess = (AuthCanAccess)AnnotationUtils.findAnnotation((Method)(method = (HandlerMethod)handler).getMethod(), AuthCanAccess.class)))) {
            return true;
        }
        HttpServletRequest request = RequestTool.getRequest();
        HttpServletResponse response = RequestTool.getResponse();
        String url = request.getRequestURI();
        if (this.adminPowerCacheService.hasPower(RequestTool.getAdminId(), url).booleanValue()) {
            return true;
        }
        if (RequestTool.isAsynchronousRequests().booleanValue()) {
            JSONObject json = new JSONObject();
            json.put("code", (Object)"SSO:01002");
            json.put("success", (Object)false);
            json.put("desc", (Object)"\u65e0\u6743\u8bbf\u95ee");
            json.put("message", (Object)"\u65e0\u6743\u8bbf\u95ee");
            response.setHeader("Content-Type", "application/json;charset=UTF-8");
            try {
                response.getWriter().write(json.toJSONString());
            }
            catch (IOException e) {
                throw new SsoException((Throwable)e);
            }
        }
        try {
            response.setHeader("Content-Type", "text/html;charset=UTF-8");
            response.getWriter().write("\u65e0\u6743\u8bbf\u95ee");
        }
        catch (IOException e) {
            throw new SsoException((Throwable)e);
        }
        return false;
    }
}

