package cn.com.duiba.sso.api.web.controller;

import cn.com.duiba.sso.api.domain.enums.SsoTypeEnum;
import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.constants.SsoProperties;
import cn.com.duiba.sso.api.event.SsoLoginSuccessEvent;
import cn.com.duiba.sso.api.remoteservice.RemotePermissionService;
import cn.com.duiba.sso.api.remoteservice.RemoteSSOService;
import cn.com.duiba.sso.api.service.eventbus.SsoEventBus;
import cn.com.duiba.sso.api.tool.CookieUtil;
import cn.com.duiba.sso.api.tool.JsonRender;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.sso.api.tool.SystemInfo;
import cn.com.duiba.sso.api.web.interceptor.annotation.AuthCanAccess;
import cn.com.duiba.sso.api.web.interceptor.annotation.CanAccess;
import cn.com.duiba.sso.api.web.power.AdminPowerCacheService;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Optional;
import java.util.Set;

@Controller
@RequestMapping("/auth")
public class AuthController {

    private static Logger logger = LoggerFactory.getLogger(AuthController.class);

    @Autowired
    private AdminPowerCacheService adminPowerCacheService;
    @Autowired
    private RemotePermissionService remotePermissionService;
    @Autowired
    private SsoProperties properties;
    @Autowired
    private RemoteSSOService remoteSSOService;
    @Autowired
    private SsoEventBus ssoEventBus;

    @Deprecated
    @CanAccess
    @RequestMapping("/ssoIndex")
    public void ssoIndex(@RequestParam Long ssoStamp,@RequestParam(required = false) String redirect,@RequestParam(defaultValue = "1") Integer ssoType) throws IOException {

        HttpServletResponse response = RequestTool.getResponse();
        try{
            Long systemId = SystemInfo.getThisSystemId();
            String ticket = remoteSSOService.findTicketByStamp(systemId,ssoStamp);
            SsoLoginSuccessEvent event = new SsoLoginSuccessEvent();

            String defaultRedirectUrl = "";

            switch (ssoType){
                case 1:
                    CookieUtil.setCookie(CookieUtil.LOGIN_COOKIE_NAME,ticket);
                    event.setSsoTypeEnum(SsoTypeEnum.PC);
                    defaultRedirectUrl = properties.getDefaultRedirectUrl();
                    break;
                case 2:
                    CookieUtil.setCookie(CookieUtil.MOBILE_USER_ID_NAME,ticket);
                    event.setSsoTypeEnum(SsoTypeEnum.DING_DING);
                    defaultRedirectUrl = properties.getMobileDefaultRedirectUrl();
                    break;
            }

            AdminDto admin = remoteSSOService.verifyTicketAndGetAdmin(ticket);
            event.setAdminId(admin.getId());
            ssoEventBus.post(event);

            String url = Optional.ofNullable(redirect).orElse(defaultRedirectUrl);

            response.sendRedirect(url);
        }catch (Exception e){
            logger.error("跳转登录失败",e);
            response.getWriter().write("跳转登录失败");
        }
    }

    /**
     * 获取用户白名单
     * @return
     */
    @AuthCanAccess
    @ResponseBody
    @RequestMapping("/getAuthList")
    public JsonRender getAuthList(){
        Set<String> urlSet = adminPowerCacheService.getAllPowerRes(RequestTool.getAdminId());
        Long version = adminPowerCacheService.version(RequestTool.getAdminId());
        JSONObject json = new JSONObject();
        json.put("version",version);
        json.put("authList",Lists.newArrayList(urlSet));
        return JsonRender.successResult(json);
    }

    @ResponseBody
    @RequestMapping(value = "/getAuthVersion",method = RequestMethod.GET)
    public JsonRender getAuthVersion(){
        JSONObject json = new JSONObject();
        json.put("version",remotePermissionService.getAdminPowerVersion(SystemInfo.getThisSystemId(),RequestTool.getAdminId()));
        return JsonRender.successResult(json);
    }

    @ResponseBody
    @RequestMapping("/cleanAuth")
    public JsonRender cleanAuth(){
        adminPowerCacheService.clean(RequestTool.getAdminId());
        return JsonRender.successResult();
    }
}
