package cn.com.duiba.sso.api.web.controller;

import cn.com.duiba.sso.api.constants.SsoProperties;
import cn.com.duiba.sso.api.domain.enums.SsoTypeEnum;
import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.event.SsoLoginSuccessEvent;
import cn.com.duiba.sso.api.remoteservice.RemoteSSOService;
import cn.com.duiba.sso.api.service.eventbus.SsoEventBus;
import cn.com.duiba.sso.api.tool.CookieUtil;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.sso.api.tool.SystemInfo;
import cn.com.duiba.sso.api.web.interceptor.annotation.CanAccess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Optional;

@Controller
@RequestMapping("/mobile/sso")
public class SsoMobileController {

    private static Logger logger = LoggerFactory.getLogger(SsoMobileController.class);

    @Autowired
    private RemoteSSOService remoteSSOService;
    @Autowired
    private SsoEventBus ssoEventBus;
    @Autowired
    private SsoProperties properties;

    /**
     * 预留新接口(版本1.5.8)
     * @param ssoStamp
     * @param redirect
     * @throws IOException
     */
    @CanAccess
    @RequestMapping("/ssoIndex")
    public void ssoIndex(@RequestParam Long ssoStamp, @RequestParam(required = false) String redirect) throws IOException {

        HttpServletResponse response = RequestTool.getResponse();
        try{
            Long systemId = SystemInfo.getThisSystemId();
            String ticket = remoteSSOService.findTicketByStamp(systemId,ssoStamp);

            CookieUtil.setCookie(CookieUtil.MOBILE_USER_ID_NAME,ticket);

            AdminDto admin = remoteSSOService.verifyTicketAndGetAdmin(ticket);

            SsoLoginSuccessEvent event = new SsoLoginSuccessEvent();
            event.setAdminId(admin.getId());
            event.setSsoTypeEnum(SsoTypeEnum.DING_DING);
            ssoEventBus.post(event);

            String url = Optional.ofNullable(redirect).orElse(properties.getMobileDefaultRedirectUrl());

            response.sendRedirect(url);
        }catch (Exception e){
            logger.error("跳转登录失败",e);
            response.getWriter().write("跳转登录失败");
        }
    }




}
