package cn.com.duiba.sso.api.web.interceptor;

import cn.com.duiba.sso.api.constants.SsoConstants;
import cn.com.duiba.sso.api.exception.SsoException;
import cn.com.duiba.sso.api.tool.JsonRender;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.sso.api.web.interceptor.annotation.CanAccess;
import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.feign.CustomRequestInterceptor;
import cn.com.duibaboot.ext.autoconfigure.core.utils.HttpRequestUtils;
import com.google.common.base.Objects;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

public class AbstractInterceptor extends HandlerInterceptorAdapter {

    private SsoFilterHandlerQueue queue;

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws IOException {

        response.setCharacterEncoding("UTF-8");
        RequestTool.setRequestInThreadLocal(request,response);
        String url = request.getRequestURI();
        if (SsoConstants.EXCLUDE_PATHS.contains(url) || isFeignRequest(request)){
            return true;
        }
        if(handler instanceof HandlerMethod){
            HandlerMethod method = (HandlerMethod)handler;
            CanAccess canAccess = AnnotationUtils.findAnnotation(method.getMethod(),CanAccess.class);
            if(!Objects.equal(null,canAccess)){
                return true;
            }
        }
        try {
            //进入拦截队列
            if(!queue.doHandler(handler)){
                return false;
            }
        } catch (SsoException e) {
            if (RequestTool.isAsynchronousRequests()){
                response.setHeader("Content-Type", "application/json;charset=UTF-8");
                response.getWriter().write(JsonRender.failResult(e).toJSONString());
            }else{
                response.setHeader("Content-Type", "text/html;charset=UTF-8");
                response.getWriter().write(e.getMessage());
            }
            return false;
        }
        return true;
    }

    @Override
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        RequestTool.removeRequestInThreadLocal();
    }

    public void setHandleQueue(SsoFilterHandlerQueue queue) {
        this.queue = queue;
    }

    /**
     * 判断是否是来自内网的Feign请求（spring-cloud调用）
     * @param request
     * @return
     */
    private boolean isFeignRequest(HttpServletRequest request){
        if (!"true".equals(request.getHeader(CustomRequestInterceptor.X_RPC))) {
            return false;
        }
        //是feign调用的情况下还得验证请求来自内网，否则会有安全问题
        if(!HttpRequestUtils.isLanRequest(request)){
            return false;
        }
        return true;
    }



}
