/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api;

import cn.com.duiba.sso.api.SsoBasicConfiguration;
import cn.com.duiba.sso.api.constants.SsoProperties;
import cn.com.duiba.sso.api.service.logger.service.SsoLoggerMateInfoAdapter;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.sso.api.web.interceptor.MobileInterceptor;
import cn.com.duiba.sso.api.web.interceptor.SsoFilterHandlerQueue;
import cn.com.duiba.sso.api.web.interceptor.SsoInterceptor;
import cn.com.duiba.sso.api.web.interceptor.annotation.MobileHandler;
import cn.com.duiba.sso.api.web.interceptor.annotation.OnlyMobileHandler;
import cn.com.duiba.sso.api.web.interceptor.handler.SsoFilterHandler;
import cn.com.duiba.sso.api.web.interceptor.handler.impl.AuthorityFilterHandler;
import cn.com.duiba.sso.api.web.interceptor.handler.impl.LoginFilterHandler;
import cn.com.duiba.sso.api.web.interceptor.handler.impl.MobileLoginFilterHandler;
import cn.com.duiba.sso.api.web.interceptor.handler.impl.SystemFilterHandler;
import cn.com.duiba.sso.api.web.logger.DefaultSsoLoggerMateInfoAdapter;
import cn.com.duiba.sso.api.web.power.AdminPowerCacheService;
import com.google.common.base.Objects;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportResource;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.Order;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
@ComponentScan(value={"cn.com.duiba.sso.api.web"})
@ConditionalOnWebApplication
@AutoConfigureAfter(value={SsoBasicConfiguration.class})
@EnableConfigurationProperties(value={SsoProperties.class})
@Import(value={SsoBasicConfiguration.class})
@ImportResource(value={"classpath:sso-api-task.xml"})
@Order(value=-1)
public class SsoAutoConfiguration
extends WebMvcConfigurerAdapter
implements ApplicationContextAware {
    @Resource
    private SsoProperties ssoProperties;
    private ApplicationContext applicationContext;

    public void addInterceptors(InterceptorRegistry registry) {
        String pathPatterns = this.ssoProperties.getPathPatterns();
        String excludePathPatterns = this.ssoProperties.getExcludePathPatterns();
        SsoInterceptor ssoInterceptor = (SsoInterceptor)((Object)this.applicationContext.getBean(SsoInterceptor.class));
        String[] paths = StringUtils.split((String)pathPatterns, (String)",");
        String[] excludePath = StringUtils.isEmpty((String)excludePathPatterns) ? new String[]{} : StringUtils.split((String)excludePathPatterns, (String)",");
        InterceptorRegistration registration = registry.addInterceptor((HandlerInterceptor)ssoInterceptor).addPathPatterns(paths).addPathPatterns(new String[]{"/auth/**"}).excludePathPatterns(excludePath);
        if (!this.ssoProperties.getMobileEnable().booleanValue()) {
            return;
        }
        String mobilePathPatterns = this.ssoProperties.getMobilePathPatterns();
        String[] mobilePaths = StringUtils.split((String)mobilePathPatterns, (String)",");
        registration.excludePathPatterns(mobilePaths);
        MobileInterceptor mobileInterceptor = (MobileInterceptor)((Object)this.applicationContext.getBean(MobileInterceptor.class));
        InterceptorRegistration mobileRegistration = registry.addInterceptor((HandlerInterceptor)mobileInterceptor).addPathPatterns(mobilePaths).excludePathPatterns(excludePath);
        if (!StringUtils.equals((String)pathPatterns, (String)"/**")) {
            mobileRegistration.excludePathPatterns(paths);
        }
    }

    @Bean
    public RequestTool initRequestTool() {
        return new RequestTool();
    }

    @Bean
    public SsoInterceptor ssoInterceptor(List<SsoFilterHandler> ssoFilterHandlers) {
        SsoFilterHandlerQueue queue = new SsoFilterHandlerQueue();
        SsoInterceptor ssoInterceptor = new SsoInterceptor();
        for (SsoFilterHandler handler : ssoFilterHandlers) {
            OnlyMobileHandler onlyMobileHandler = (OnlyMobileHandler)AnnotationUtils.findAnnotation(handler.getClass(), OnlyMobileHandler.class);
            if (!Objects.equal(null, (Object)onlyMobileHandler)) continue;
            queue.addHandler(handler);
        }
        ssoInterceptor.setHandleQueue(queue);
        return ssoInterceptor;
    }

    @Bean
    @ConditionalOnProperty(name={"duiba.sso.mobile-enable"}, havingValue="true", matchIfMissing=false)
    public MobileInterceptor mobileInterceptor(List<SsoFilterHandler> ssoFilterHandlers) {
        SsoFilterHandlerQueue queue = new SsoFilterHandlerQueue();
        MobileInterceptor mobileInterceptor = new MobileInterceptor();
        for (SsoFilterHandler handler : ssoFilterHandlers) {
            MobileHandler mobileHandler = (MobileHandler)AnnotationUtils.findAnnotation(handler.getClass(), MobileHandler.class);
            OnlyMobileHandler onlyMobileHandler = (OnlyMobileHandler)AnnotationUtils.findAnnotation(handler.getClass(), OnlyMobileHandler.class);
            if (Objects.equal(null, (Object)mobileHandler) && Objects.equal(null, (Object)onlyMobileHandler)) continue;
            queue.addHandler(handler);
        }
        mobileInterceptor.setHandleQueue(queue);
        return mobileInterceptor;
    }

    @Bean
    public AdminPowerCacheService adminPowerCacheService() {
        return new AdminPowerCacheService();
    }

    @Bean
    @ConditionalOnMissingBean
    public SsoLoggerMateInfoAdapter ssoLoggerMateInfoAdapter() {
        return new DefaultSsoLoggerMateInfoAdapter();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Bean
    public SsoFilterHandler loginFilterHandler() {
        return new LoginFilterHandler();
    }

    @Bean
    @ConditionalOnProperty(name={"duiba.sso.mobile-enable"}, havingValue="true", matchIfMissing=false)
    public SsoFilterHandler mobileLoginFilterHandler() {
        return new MobileLoginFilterHandler();
    }

    @Bean
    public SsoFilterHandler systemFilterHandler() {
        return new SystemFilterHandler();
    }

    @Bean
    public SsoFilterHandler authorityFilterHandler() {
        return new AuthorityFilterHandler();
    }
}

