/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.web.interceptor;

import cn.com.duiba.sso.api.constants.SsoConstants;
import cn.com.duiba.sso.api.exception.SsoException;
import cn.com.duiba.sso.api.tool.JsonRender;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.sso.api.web.interceptor.SsoFilterHandlerQueue;
import cn.com.duiba.sso.api.web.interceptor.annotation.CanAccess;
import cn.com.duibaboot.ext.autoconfigure.core.utils.HttpRequestUtils;
import com.google.common.base.Objects;
import java.io.IOException;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class AbstractInterceptor
extends HandlerInterceptorAdapter {
    private SsoFilterHandlerQueue queue;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws IOException {
        HandlerMethod method;
        CanAccess canAccess;
        response.setCharacterEncoding("UTF-8");
        RequestTool.setRequestInThreadLocal(request, response);
        String url = request.getRequestURI();
        if (SsoConstants.EXCLUDE_PATHS.contains(url) || this.isFeignRequest(request)) {
            return true;
        }
        if (handler instanceof HandlerMethod && !Objects.equal(null, (Object)(canAccess = (CanAccess)AnnotationUtils.findAnnotation((Method)(method = (HandlerMethod)handler).getMethod(), CanAccess.class)))) {
            return true;
        }
        try {
            if (!this.queue.doHandler(handler).booleanValue()) {
                return false;
            }
        }
        catch (SsoException e) {
            if (RequestTool.isAsynchronousRequests().booleanValue()) {
                response.setHeader("Content-Type", "application/json;charset=UTF-8");
                response.getWriter().write(JsonRender.failResult(e).toJSONString());
            } else {
                response.setHeader("Content-Type", "text/html;charset=UTF-8");
                response.getWriter().write(e.getMessage());
            }
            return false;
        }
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        RequestTool.removeRequestInThreadLocal();
    }

    public void setHandleQueue(SsoFilterHandlerQueue queue) {
        this.queue = queue;
    }

    private boolean isFeignRequest(HttpServletRequest request) {
        if (!"true".equals(request.getHeader("X-Rpc"))) {
            return false;
        }
        return HttpRequestUtils.isLanRequest((HttpServletRequest)request);
    }
}

