/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.web.interceptor.handler.impl;

import cn.com.duiba.sso.api.constants.SsoProperties;
import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.exception.SsoException;
import cn.com.duiba.sso.api.properties.SsoBasicProperties;
import cn.com.duiba.sso.api.remoteservice.RemoteSSOService;
import cn.com.duiba.sso.api.tool.CookieUtil;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.sso.api.tool.SystemInfo;
import cn.com.duiba.sso.api.web.interceptor.handler.impl.AbstractLoginFilterHandler;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginFilterHandler
extends AbstractLoginFilterHandler {
    private static Logger logger = LoggerFactory.getLogger(LoginFilterHandler.class);
    @Resource
    private RemoteSSOService remoteSSOService;
    @Resource
    protected SsoBasicProperties properties;
    @Resource
    protected SsoProperties ssoProperties;

    @Override
    public Boolean before(Object handler) {
        String ticket = RequestTool.findTicket();
        if (StringUtils.isBlank((CharSequence)ticket)) {
            this.returnNotLogin();
            return false;
        }
        try {
            AdminDto admin = this.remoteSSOService.verifyTicketAndGetAdmin(ticket);
            if (admin == null) {
                throw new SsoException("\u901a\u884c\u8bc1\u5931\u6548");
            }
            RequestTool.setAdmin(admin);
            if (RequestTool.getRequestParamMap().containsKey("sso_ticket")) {
                CookieUtil.setCookie("sso_ticket", ticket);
            }
            return true;
        }
        catch (Exception e) {
            logger.info("\u901a\u884c\u8bc1\u9a8c\u8bc1\u5931\u8d25", (Throwable)e);
            this.returnNotLogin();
            return false;
        }
    }

    @Override
    protected String getLoginRedirectUrl(String redirect) {
        StringBuilder builder = new StringBuilder();
        String loginUrl = this.properties.getSsoSystemUrl() + "/login";
        builder.append(loginUrl).append("?redirect=").append(redirect);
        builder.append("&systemId=").append(SystemInfo.getThisSystemId());
        return builder.toString();
    }

    @Override
    protected String getDefaultRedirectUrl() {
        return this.ssoProperties.getDefaultRedirectUrl();
    }
}

