package cn.com.duiba.sso.api.config;

import org.apache.commons.lang.StringUtils;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.env.*;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class SsoWebEnvApplicationInitializer implements EnvironmentPostProcessor {

    @Override
    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        Properties properties = new Properties();
        properties.put("duiba.security.csrf.enable",true);
        PropertiesPropertySource propertiesPropertySource = new PropertiesPropertySource("ssoWebConfig", properties);
        environment.getPropertySources().addLast(propertiesPropertySource);
    }
}
