package cn.com.duiba.sso.api.tool;

import javax.servlet.http.Cookie;

/**
 * Created by liuyao on 2017/5/11.
 */
public class CookieUtil {

    public static final String LOGIN_COOKIE_NAME = "sso_ticket";
    //钉钉：userId  微信：openId
    public static final String MOBILE_USER_ID_NAME = "sso_user_id";

    public static final int COOKIE_TIME_OUT = 24*60*60;

    /**
     * 如果是线上环境，对应到.duiba.com.cn；如果是测试环境或者预发环境，通过配置项读取
     */
    public static Cookie createCookie(String name, String value) {
        Cookie cookie = new Cookie(name, value);
        cookie.setPath("/");
        cookie.setMaxAge(COOKIE_TIME_OUT);
        return cookie;
    }

    /**
     * 设置cookie
     */
    public static void setCookie(String name, String value) {
        Cookie cookie = createCookie(name, value);
        RequestTool.addCookie(cookie);
    }

    /**
     * 设置登录令牌
     */
    public static void setLoginCookie(String ticket){
        Cookie cookie = createCookie(LOGIN_COOKIE_NAME, ticket);
        RequestTool.addCookie(cookie);
    }

    public static void deleteCookie(String name){
        Cookie cookie=createCookie(name,null);
        cookie.setMaxAge(0);
        RequestTool.addCookie(cookie);
    }

    /**
     * 根据名字获取cookie
     */
    public static String getCookie(String name) {
        return RequestTool.getCookie(name);
    }

}
