package cn.com.duiba.sso.api.web.controller;

import cn.com.duiba.sso.api.remoteservice.RemotePermissionService;
import cn.com.duiba.sso.api.tool.JsonRender;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.sso.api.tool.SystemInfo;
import cn.com.duiba.sso.api.web.interceptor.annotation.AuthCanAccess;
import cn.com.duiba.sso.api.web.power.AdminPowerCacheService;
import cn.com.duiba.sso.api.web.power.SsoAuthPostProcessor;
import cn.com.duibaboot.ext.autoconfigure.security.dpefensivepolicy.CsrfOff;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;
import java.util.Set;

@Controller
@RequestMapping({"/auth","/sso/auth"})
public class AuthController {

    @Autowired
    private AdminPowerCacheService adminPowerCacheService;
    @Autowired
    private RemotePermissionService remotePermissionService;
    @Autowired(required = false)
    private List<SsoAuthPostProcessor> postProcessorList;

    /**
     * 获取用户白名单
     */
    @AuthCanAccess
    @ResponseBody
    @RequestMapping("/getAuthList")
    public JsonRender getAuthList(){
        Set<String> urlSet = adminPowerCacheService.getAllPowerRes(RequestTool.getAdminId());

        if(postProcessorList!=null){
            for(SsoAuthPostProcessor postProcessor:postProcessorList){
                urlSet = postProcessor.postProcessBeanFactory(urlSet);
            }
        }
        Long version = adminPowerCacheService.version(RequestTool.getAdminId());
        JSONObject json = new JSONObject();
        json.put("version",version);
        json.put("authList",Lists.newArrayList(urlSet));
        return JsonRender.successResult(json);
    }

    @ResponseBody
    @RequestMapping(value = "/getAuthVersion",method = RequestMethod.GET)
    public JsonRender getAuthVersion(){
        JSONObject json = new JSONObject();
        json.put("version",remotePermissionService.getAdminPowerVersion(SystemInfo.getThisSystemId(),RequestTool.getAdminId()));
        return JsonRender.successResult(json);
    }

    @CsrfOff
    @ResponseBody
    @RequestMapping("/cleanAuth")
    public JsonRender cleanAuth(){
        adminPowerCacheService.clean(RequestTool.getAdminId());
        return JsonRender.successResult();
    }
}
