/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.service;

import cn.com.duiba.sso.api.service.HostEnvironment;
import cn.com.duiba.sso.api.service.system.EnvironmentEnum;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;

public class HostEnvironmentMapping {
    @Resource
    private EnvironmentEnum environmentEnum;
    private Map<String, EnvironmentEnum> mapping = Maps.newHashMap();
    private List<HostEnvironment> relationList = Lists.newArrayList();
    private Map<EnvironmentEnum, String> publicMapping = Maps.newHashMap();

    public void addMapping(String host, EnvironmentEnum environmentEnum) {
        this.addMapping(host, environmentEnum, true);
    }

    public void addMapping(String host, EnvironmentEnum environmentEnum, boolean isPublic) {
        this.mapping.put(host, environmentEnum);
        if (isPublic) {
            this.relationList.add(new HostEnvironment(host, environmentEnum));
            this.publicMapping.put(environmentEnum, host);
        }
    }

    public String findHostByEnvironment(EnvironmentEnum environment) {
        return this.publicMapping.get(environment);
    }

    public EnvironmentEnum findEnvironmentByHost(String host) {
        return this.mapping.getOrDefault(host, this.environmentEnum);
    }

    public Boolean containsHost(String host) {
        return this.mapping.containsKey(host);
    }

    public List<HostEnvironment> getHostEnvironmentMappings() {
        return Lists.newArrayList(this.relationList);
    }
}

