/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.tool;

import cn.com.duiba.sso.api.tool.RequestTool;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.util.IOUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonRender
extends JSONObject {
    private static final Logger log = LoggerFactory.getLogger(JsonRender.class);
    private static final String SUCCESS = "success";
    private static final String MESSAGE = "message";
    private static final String CALLBACK = "callback";
    private static final String DATA = "data";

    private JsonRender() {
    }

    public static JsonRender successResult() {
        JsonRender resp = new JsonRender();
        resp.put(SUCCESS, true);
        return resp;
    }

    public static JsonRender successResult(JSONObject model) {
        JsonRender resp = new JsonRender();
        resp.put(SUCCESS, true);
        resp.putAll((Map)model);
        return resp;
    }

    public static JsonRender successResult(Object obj) {
        JsonRender resp = new JsonRender();
        resp.put(SUCCESS, true);
        resp.put(DATA, obj);
        return resp;
    }

    public JsonRender setData(Object obj) {
        this.put(DATA, obj);
        return this;
    }

    public static JsonRender failResult(String message) {
        JsonRender resp = new JsonRender();
        resp.put(SUCCESS, false);
        resp.put(MESSAGE, message);
        return resp;
    }

    public static JsonRender failResult(Throwable e) {
        JsonRender resp = new JsonRender();
        resp.put(SUCCESS, false);
        resp.put(MESSAGE, e.getMessage());
        return resp;
    }

    public JsonRender setJSONPCallback(String callback) {
        this.put(CALLBACK, callback);
        return this;
    }

    public boolean isSuccess() {
        return this.getBoolean(SUCCESS);
    }

    public JsonRender setMessage(String message) {
        this.put(MESSAGE, message);
        return this;
    }

    public JsonRender addResult(String key, Object result) {
        this.put(key, result);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forJsonpReturn(String callback) {
        PrintWriter out = null;
        try {
            out = RequestTool.getResponse().getWriter();
            out.write(callback + "(" + this.toJSONString() + ")");
        }
        catch (IOException e) {
            log.error("e={}", (Throwable)e);
        }
        finally {
            IOUtils.close((Closeable)out);
        }
    }
}

