/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.web.interceptor.handler.impl;

import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.exception.SsoRunTimeException;
import cn.com.duiba.sso.api.remoteservice.RemoteSSOService;
import cn.com.duiba.sso.api.tool.CookieUtil;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.sso.api.web.interceptor.handler.SsoFilterHandler;
import com.alibaba.fastjson.JSONObject;
import java.net.URLEncoder;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractLoginFilterHandler
implements SsoFilterHandler {
    @Autowired
    private RemoteSSOService remoteSSOService;

    protected abstract String getDefaultRedirectUrl();

    protected abstract String getLoginRedirectUrl();

    public int getOrder() {
        return 0;
    }

    protected AdminDto verifyTicket(String ticket) {
        if (StringUtils.isBlank((CharSequence)ticket)) {
            return null;
        }
        AdminDto admin = this.remoteSSOService.verifyTicketAndGetAdmin(ticket);
        if (Objects.nonNull(admin) && StringUtils.isBlank((CharSequence)RequestTool.getCookie("sso_ticket"))) {
            CookieUtil.setLoginCookie(ticket, admin.getLoginTimeout());
        }
        return admin;
    }

    protected String getCurrentRedirect() {
        HttpServletRequest request = RequestTool.getRequest();
        String redirect = StringUtils.equals((CharSequence)"/", (CharSequence)request.getRequestURI()) ? RequestTool.getHomeURL() + this.getDefaultRedirectUrl() : RequestTool.getUrl();
        try {
            return URLEncoder.encode(redirect, "utf-8");
        }
        catch (Exception e) {
            throw new SsoRunTimeException((Throwable)e);
        }
    }

    protected void returnNotLogin() {
        try {
            if (RequestTool.isAsynchronousRequests().booleanValue()) {
                RequestTool.getResponse().setHeader("Content-Type", "application/json;charset=UTF-8");
                JSONObject model = new JSONObject();
                model.put("code", (Object)"SSO:01001");
                model.put("success", (Object)false);
                model.put("notLogin", (Object)true);
                model.put("message", (Object)"\u767b\u5f55\u5931\u6548\uff0c\u8bf7\u5237\u65b0\u9875\u9762");
                RequestTool.getResponse().getWriter().write(model.toJSONString());
            } else {
                RequestTool.getResponse().sendRedirect(this.getLoginRedirectUrl());
            }
        }
        catch (Exception e) {
            throw new SsoRunTimeException((Throwable)e);
        }
    }
}

