/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.web.controller;

import cn.com.duiba.sso.api.constants.SsoProperties;
import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.remoteservice.RemoteSSOService;
import cn.com.duiba.sso.api.tool.CookieUtil;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.sso.api.tool.SystemInfo;
import cn.com.duiba.sso.api.web.interceptor.annotation.CanAccess;
import java.io.IOException;
import java.util.Optional;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/mobile/sso"})
public class SsoMobileController {
    private static Logger logger = LoggerFactory.getLogger(SsoMobileController.class);
    @Autowired
    private RemoteSSOService remoteSSOService;
    @Autowired
    private SsoProperties properties;

    @CanAccess
    @RequestMapping(value={"/ssoIndex"})
    public void ssoIndex(@RequestParam Long ssoStamp, @RequestParam(required=false) String redirect) throws IOException {
        HttpServletResponse response = RequestTool.getResponse();
        try {
            redirect = this.fixRedirect(redirect);
            Long systemId = SystemInfo.getThisSystemId();
            String ticket = this.remoteSSOService.findTicketByStamp(systemId, ssoStamp);
            AdminDto admin = this.remoteSSOService.verifyTicketAndGetAdmin(ticket);
            CookieUtil.setCookie("sso_ticket", ticket, admin.getLoginTimeout());
            String url = Optional.ofNullable(redirect).orElse(this.properties.getMobileDefaultRedirectUrl());
            response.sendRedirect(url);
        }
        catch (Exception e) {
            logger.error("\u8df3\u8f6c\u767b\u5f55\u5931\u8d25", (Throwable)e);
            response.getWriter().write("\u8df3\u8f6c\u767b\u5f55\u5931\u8d25");
        }
    }

    private String fixRedirect(String url) {
        if (StringUtils.isBlank((String)url)) {
            return url;
        }
        return StringEscapeUtils.unescapeHtml3((String)url);
    }
}

