/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.web.interceptor.handler.impl;

import cn.com.duiba.sso.api.constants.SsoProperties;
import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.domain.dto.SystemDto;
import cn.com.duiba.sso.api.domain.enums.SystemSwitches;
import cn.com.duiba.sso.api.service.SsoUrlService;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.sso.api.tool.SystemInfo;
import cn.com.duiba.sso.api.web.interceptor.annotation.PcHandler;
import cn.com.duiba.sso.api.web.interceptor.handler.impl.AbstractLoginFilterHandler;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;

@PcHandler
public class LoginFilterHandler
extends AbstractLoginFilterHandler {
    @Resource
    private SsoProperties ssoProperties;
    @Resource
    private SsoUrlService ssoUrlService;

    @Override
    public Boolean before(Object handler) {
        String ticket = RequestTool.findTicket();
        if (StringUtils.isBlank((CharSequence)ticket)) {
            this.returnNotLogin();
            return false;
        }
        AdminDto admin = this.verifyTicket(ticket);
        if (admin == null) {
            this.returnNotLogin();
            return false;
        }
        SystemDto system = SystemInfo.getThisSystemInfo();
        if (admin.getModelAuthorize().booleanValue() && !system.switchIsOpen(SystemSwitches.CAN_MOBILE_TO_PC).booleanValue()) {
            this.returnNotLogin();
            return false;
        }
        RequestTool.setAdmin(admin);
        return true;
    }

    @Override
    protected String getLoginRedirectUrl() {
        String redirect = this.getCurrentRedirect();
        StringBuilder builder = new StringBuilder();
        String loginUrl = this.ssoUrlService.getSsoHomeUrl() + "/login";
        builder.append(loginUrl).append("?redirect=").append(redirect);
        builder.append("&systemId=").append(SystemInfo.getThisSystemId());
        return builder.toString();
    }

    @Override
    protected String getDefaultRedirectUrl() {
        return this.ssoProperties.getDefaultRedirectUrl();
    }
}

