package cn.com.duiba.sso.api.web.controller;

import cn.com.duiba.application.boot.api.component.environment.RequestEnvironmentDecisionMaker;
import cn.com.duiba.application.boot.api.domain.dto.ApplicationDto;
import cn.com.duiba.sso.api.constants.SsoProperties;
import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.exception.SsoException;
import cn.com.duiba.sso.api.remoteservice.RemoteSSOService;
import cn.com.duiba.sso.api.tool.CookieUtil;
import cn.com.duiba.sso.api.tool.JsonRender;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.sso.api.tool.SystemInfo;
import cn.com.duiba.sso.api.web.interceptor.annotation.CanAccess;
import cn.com.duibaboot.ext.autoconfigure.web.login.LoginSuccessEvent;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Optional;

@Controller
@RequestMapping({"/mobile/sso","/sso"})
public class SsoController {

    private static Logger logger = LoggerFactory.getLogger(AuthController.class);

    @Resource
    private RemoteSSOService remoteSSOService;
    @Resource
    private SsoProperties properties;
    @Resource
    private ApplicationContext applicationContext;
    @Resource
    private RequestEnvironmentDecisionMaker requestEnvironmentDecisionMaker;

    @CanAccess
    @RequestMapping("/ssoIndex")
    public void ssoIndex(@RequestParam Long ssoStamp,@RequestParam(required = false) String redirect) throws IOException {

        HttpServletResponse response = RequestTool.getResponse();
        try{
            redirect = fixRedirect(redirect);
            Long systemId = SystemInfo.getThisSystemId();
            String ticket = remoteSSOService.findTicketByStamp(systemId,ssoStamp);
            if(StringUtils.isBlank(ticket)){
                throw new SsoException("获取SSO通行证失败");
            }
            AdminDto admin = remoteSSOService.verifyTicketAndGetAdmin(ticket);
            if(admin==null){
                throw new SsoException("ticket失效");
            }
            CookieUtil.setLoginCookie(ticket);

            String deviceNo = RequestTool.findDeviceNo();
            if(StringUtils.isNotBlank(deviceNo)){
                CookieUtil.setCookie(CookieUtil.DEVICE_NO,deviceNo,15*365*24*3600);
            }

            LoginSuccessEvent event = new LoginSuccessEvent();
            event.setSession(admin);
            event.setRequest(RequestTool.getRequest());
            event.setResponse(RequestTool.getResponse());
            event.setExpirationTime(admin.getLoginTimeout());
            applicationContext.publishEvent(event);

            String url = Optional.ofNullable(redirect).orElse(properties.getDefaultRedirectUrl());

            response.sendRedirect(url);
        }catch (Exception e){
            logger.debug("跳转登录失败",e);
            response.getWriter().write("跳转登录失败");
        }
    }


    /**
     * 当前的系统信息
     */
    @CanAccess
    @ResponseBody
    @RequestMapping(value = "/systemInfo")
    public JsonRender systemInfo(){

        JsonRender render = JsonRender.successResult();
        render.put("ssoHomeURL",remoteSSOService.findSsoHomeUrl());
        ApplicationDto systemDto = SystemInfo.getThisSystemInfo();
        render.put("system",systemDto);
        render.put("environment",requestEnvironmentDecisionMaker.getRequestEnvironment().getEnvId());

        return render;
    }

    private String fixRedirect(String url){
        if(StringUtils.isBlank(url)){
            return url;
        }
        return StringEscapeUtils.unescapeHtml3(url);
    }

    @ResponseBody
    @RequestMapping(value = "/outLogin")
    public JsonRender outLogin(){
        RequestTool.outLogin();
        return JsonRender.successResult();
    }

}
