/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.web.controller;

import cn.com.duiba.sso.api.remoteservice.RemotePermissionService;
import cn.com.duiba.sso.api.tool.JsonRender;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.sso.api.tool.SystemInfo;
import cn.com.duiba.sso.api.web.interceptor.annotation.AuthCanAccess;
import cn.com.duiba.sso.api.web.power.AdminPowerCacheService;
import cn.com.duiba.sso.api.web.power.SsoAuthPostProcessor;
import cn.com.duibaboot.ext.autoconfigure.security.dpefensivepolicy.CsrfOff;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/auth", "/${duiba.sso.root-path:'/sso'}/auth", "/mobile/sso/auth"})
public class AuthController {
    @Autowired
    private AdminPowerCacheService adminPowerCacheService;
    @Autowired
    private RemotePermissionService remotePermissionService;
    @Autowired(required=false)
    private List<SsoAuthPostProcessor> postProcessorList;

    @AuthCanAccess
    @ResponseBody
    @RequestMapping(value={"/getAuthList"})
    public JsonRender getAuthList() {
        Set<String> urlSet = this.adminPowerCacheService.getAllPowerRes(RequestTool.getAdminId());
        if (this.postProcessorList != null) {
            for (SsoAuthPostProcessor postProcessor : this.postProcessorList) {
                urlSet = postProcessor.postProcessBeanFactory(urlSet);
            }
        }
        Long version = this.adminPowerCacheService.version(RequestTool.getAdminId());
        JSONObject json = new JSONObject();
        json.put("version", (Object)version);
        json.put("authList", (Object)Lists.newArrayList(urlSet));
        return JsonRender.successResult(json);
    }

    @ResponseBody
    @RequestMapping(value={"/getAuthVersion"}, method={RequestMethod.GET})
    public JsonRender getAuthVersion() {
        JSONObject json = new JSONObject();
        json.put("version", (Object)this.remotePermissionService.getAdminPowerVersion(SystemInfo.getThisSystemId(), RequestTool.getAdminId()));
        return JsonRender.successResult(json);
    }

    @CsrfOff
    @ResponseBody
    @RequestMapping(value={"/cleanAuth"})
    public JsonRender cleanAuth() {
        this.adminPowerCacheService.clean(RequestTool.getAdminId());
        return JsonRender.successResult();
    }
}

