package cn.com.duiba.sso.api.web.power;

import cn.com.duiba.sso.api.exception.SsoException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.context.ApplicationContext;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

import javax.annotation.Resource;
import java.lang.reflect.Method;


@Aspect
public class AuthorizeInterceptor {

    @Resource
    private ApplicationContext applicationContext;

    private ExpressionParser parser = new SpelExpressionParser();

    private LocalVariableTableParameterNameDiscoverer discoverer = new LocalVariableTableParameterNameDiscoverer();

    @Pointcut(value = "@annotation(PreAuthorize)")
    private void getPointcut() {
    }

    @Around("getPointcut()")
    public Object preProcessQueryPattern(ProceedingJoinPoint point) throws Throwable {

        Object[] arguments = point.getArgs();
        MethodSignature signature = (MethodSignature) point.getSignature();
        Method method = signature.getMethod();

        PreAuthorize preAuthorize = AnnotationUtils.findAnnotation(method, PreAuthorize.class);
        String[] paramNames = discoverer.getParameterNames(method);
        Expression expression = parser.parseExpression(preAuthorize.value());
        StandardEvaluationContext context = new StandardEvaluationContext();
        for (int i = 0; i < arguments.length; i++) {
            context.setVariable(paramNames[i], arguments[i]);
        }
        context.setBeanResolver(new BeanFactoryResolver(applicationContext));

        expression.getValue(context, Void.class);

        return point.proceed();
    }

}
