package cn.com.duiba.sso.api.tool;

import javax.servlet.http.Cookie;

/**
 * Created by liuyao on 2017/5/11.
 */
public class CookieUtil {

    public static final String LOGIN_COOKIE_NAME = "sso_ticket";

    /**
     * 如果是线上环境，对应到.duiba.com.cn；如果是测试环境或者预发环境，通过配置项读取
     */
    public static Cookie createCookie(String name, String value,Integer timeout) {
        Cookie cookie = new Cookie(name, value);
        cookie.setPath("/");
        cookie.setMaxAge(timeout);
        return cookie;
    }

    /**
     * 设置cookie
     */
    public static void setCookie(String name, String value,Integer timeout) {
        Cookie cookie = createCookie(name, value,timeout);
        RequestTool.addCookie(cookie);
    }

    /**
     * 设置登录令牌
     */
    public static void setLoginCookie(String ticket,Integer timeout){
        Cookie cookie = createCookie(LOGIN_COOKIE_NAME,ticket,timeout);
        RequestTool.addCookie(cookie);
    }

    public static void deleteCookie(String name){
        Cookie cookie=createCookie(name,null,0);
        RequestTool.addCookie(cookie);
    }

    /**
     * 根据名字获取cookie
     */
    public static String getCookie(String name) {
        return RequestTool.getCookie(name);
    }

}
