package cn.com.duiba.sso.api.service;

import cn.com.duiba.application.boot.api.component.environment.Environment;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

public class HostEnvironmentMapping {

    @Resource
    private Environment currentEnvironment;

    private Map<String, HostEnvironment> mapping = Maps.newHashMap();

    private List<HostEnvironment> relationList = Lists.newArrayList();

    public void addMapping(String host,Environment environment,boolean isPublic){
        addMapping(host,environment,"default",isPublic);
    }

    public void addMapping(String host,Environment environment,String cluster,boolean isPublic){
        HostEnvironment hostEnvironment = new HostEnvironment(host,environment,cluster);
        mapping.put(host,hostEnvironment);
        if(isPublic){
            relationList.add(hostEnvironment);
        }
    }


    public Environment findEnvironmentByHost(String host){

        if(!mapping.containsKey(host)){
            return currentEnvironment;
        }
        HostEnvironment hostEnvironment = mapping.get(host);
        return hostEnvironment.getEnvironment();
    }

    public Boolean containsHost(String host){
        return mapping.containsKey(host);
    }

    public List<HostEnvironment> getHostEnvironmentMappings(){
        return Lists.newArrayList(relationList);
    }

}
