package cn.com.duiba.sso.api.web.export;

import cn.com.duiba.sso.api.tool.FileUtils;
import cn.com.duiba.wolf.utils.UUIDUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;

import java.io.File;
import java.util.Objects;


@Scope("prototype")
public abstract class BaseExportRunnable implements Runnable {

    private final String taskId = UUIDUtils.createUUID();

    @Autowired
    private SsoExportFileService ssoExportFileService;

    private File file;

    void init(){
        ExportFileInfo info = new ExportFileInfo();
        info.setTaskId(taskId);
        info.setSuccessCount(0);
        info.setCount(count());
        info.setSuccess(false);
        info.setUrl("");

        String fileName = fileName();
        String fileType = fileType();

        File tempDir = FileUtils.getTempDir();
        file =  new File(tempDir, fileName+"-"+System.currentTimeMillis()+"."+fileType);
        info.setFileName(file.getName());
        ssoExportFileService.publishExportFileInfo(info);
    }

    /**
     * 获取导出任务Id
     */
    public String getTaskId(){
        return taskId;
    }

    protected File getExportFile(){
        return file;
    }

    public void setIncrementCount(Integer count){

        Objects.requireNonNull(count);
        if(count==0){
            return;
        }
        ExportFileInfo info = ssoExportFileService.getExportFileInfo(taskId);
        info.setSuccessCount(info.getSuccessCount()+count);
        ssoExportFileService.publishExportFileInfo(info);
    }

    protected abstract Integer count();

    protected abstract String fileName();

    protected abstract String fileType();

    /**
     * 导出完成之后，下发给客户端一个能够全网访问的文件地址
     */
    protected void complete(String url){
        ExportFileInfo info = ssoExportFileService.getExportFileInfo(taskId);
        info.setUrl(url);
        info.setSuccess(true);
        ssoExportFileService.publishExportFileInfo(info);
    }

    protected void error(String message){
        ExportFileInfo info = ssoExportFileService.getExportFileInfo(taskId);
        info.setMessage(message);
        info.setSuccess(true);
        ssoExportFileService.publishExportFileInfo(info);
    }

}
