/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.tool;

import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.exception.SsoException;
import cn.com.duiba.sso.api.exception.SsoRunTimeException;
import cn.com.duiba.sso.api.remoteservice.RemoteAdminService;
import cn.com.duiba.sso.api.remoteservice.RemoteSSOService;
import cn.com.duiba.sso.api.service.OutLoginEvent;
import cn.com.duiba.sso.api.tool.CookieUtil;
import cn.com.duiba.sso.api.tool.RequestParams;
import cn.com.duiba.wolf.utils.UUIDUtils;
import com.alibaba.ttl.TransmittableThreadLocal;
import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class RequestTool {
    private static ThreadLocal<RequestTool> local = new ThreadLocal();
    private static TransmittableThreadLocal<RequestParams> TTL = new TransmittableThreadLocal();
    private static RemoteAdminService remoteAdminService;
    private static RemoteSSOService remoteSSOService;
    private static ApplicationContext applicationContext;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private String uuid = UUIDUtils.createUUID();

    public static void setRequestInThreadLocal(HttpServletRequest request, HttpServletResponse response) {
        if (request == null) {
            throw new SsoRunTimeException("RequestTool\u6ce8\u5165request\u4e3a\u7a7a");
        }
        if (response == null) {
            throw new SsoRunTimeException("RequestTool\u6ce8\u5165response\u4e3a\u7a7a");
        }
        RequestTool tool = new RequestTool();
        tool.request = request;
        tool.response = response;
        TTL.set((Object)RequestTool.createRequestParams(request));
        local.set(tool);
    }

    private static RequestTool get() {
        if (local.get() == null) {
            throw new SsoRunTimeException("\u8bf7\u5728\u767b\u5f55\u62e6\u622a\u5668\u4e2d\u8c03\u7528setRequestInThreadLocal,\u6216\u8005\u8bf7\u68c0\u67e5\u662f\u5426\u5728\u5f02\u6b65\u7ebf\u7a0b\u4e2d\u4f7f\u7528RequestTool,\u5982\u679c\u6709\u5f02\u6b65\u573a\u666f\u8981\u83b7\u53d6\u7528\u6237\u4fe1\u606f,\u8bf7\u5728\u5f02\u6b65\u7ebf\u7a0b\u542f\u52a8\u4e4b\u524d\u4f7f\u7528getRequestParams\u83b7\u53d6\u5f53\u524d\u7528\u6237\u7684\u8bf7\u6c42\u5c01\u88c5\u4fe1\u606f");
        }
        return local.get();
    }

    public static RequestParams getRequestParams() {
        RequestParams params = (RequestParams)TTL.get();
        if (params == null) {
            throw new SsoRunTimeException("\u975e\u7528\u6237\u8bf7\u6c42\u7ebf\u7a0b\uff0c\u65e0\u6cd5\u83b7\u53d6\u7528\u6237\u8bf7\u6c42\u6570\u636e");
        }
        return params;
    }

    public static HttpServletResponse getResponse() {
        return RequestTool.get().response;
    }

    public static HttpServletRequest getRequest() {
        return RequestTool.get().request;
    }

    public static void removeRequestInThreadLocal() {
        local.remove();
        TTL.remove();
    }

    public static Long getAdminId() {
        AdminDto admin = RequestTool.getAdmin();
        return Optional.ofNullable(admin).map(AdminDto::getId).orElse(null);
    }

    public static AdminDto getAdmin() {
        RequestParams param = RequestTool.getRequestParams();
        return param.getAdmin();
    }

    public static void setAdmin(AdminDto admin) {
        RequestParams param = RequestTool.getRequestParams();
        param.setAdmin(admin);
    }

    public static void addCookie(Cookie cookie) {
        if (cookie == null) {
            return;
        }
        RequestTool tool = RequestTool.get();
        if (tool == null) {
            throw new SsoRunTimeException("\u7528\u6237\u7ebf\u7a0b\u5df2\u7ecf\u7ed3\u675f");
        }
        RequestParams params = RequestTool.getRequestParams();
        params.addCookie(cookie.getName(), cookie.getValue());
        tool.response.addCookie(cookie);
    }

    public static String getUrl() {
        RequestParams params = RequestTool.getRequestParams();
        return params.getUrl();
    }

    public static boolean isHttpsRequest() {
        HttpServletRequest request = RequestTool.get().request;
        return Boolean.parseBoolean(request.getHeader("Use-Https"));
    }

    public static String getCookie(String name) {
        RequestParams params = RequestTool.getRequestParams();
        return params.getCookie(name);
    }

    public static Map<String, String> getRequestParamMap() {
        HttpServletRequest request = RequestTool.get().request;
        Map map = request.getParameterMap();
        HashMap<String, String> resultMap = new HashMap<String, String>();
        for (Map.Entry entry : map.entrySet()) {
            String[] values = (String[])entry.getValue();
            if (values.length == 0) continue;
            resultMap.put((String)entry.getKey(), ((String[])entry.getValue())[0]);
        }
        return resultMap;
    }

    public static Boolean isAsynchronousRequests() {
        HttpServletRequest request = RequestTool.get().request;
        String re = request.getHeader("x-requested-with");
        String accept = request.getHeader("Accept");
        return StringUtils.isNotBlank((String)re) && StringUtils.equals((String)"XMLHttpRequest", (String)re) || StringUtils.isNotBlank((String)accept) && accept.contains("json");
    }

    public static String getIp() {
        RequestParams params = RequestTool.getRequestParams();
        return params.getIp();
    }

    public static String getRequestUUID() {
        RequestTool tool = RequestTool.get();
        return tool.uuid;
    }

    public static Boolean isLocalHost() {
        RequestParams params = RequestTool.getRequestParams();
        return Objects.equal((Object)params.getIp(), (Object)"127.0.0.1");
    }

    public static void googleVerify(String code) throws SsoException {
        Long adminId = RequestTool.getAdminId();
        Boolean result = remoteAdminService.googleCodeVerify(adminId, code);
        if (!result.booleanValue()) {
            throw new SsoException("\u52a8\u6001\u7801\u9a8c\u8bc1\u5931\u8d25");
        }
    }

    public static String getHomeURL() {
        return RequestTool.parseHomeUrl(RequestTool.getRequest());
    }

    public static String findTicket() {
        String ticketForUrl = RequestTool.getRequestParamMap().get("sso_ticket");
        if (StringUtils.isNotBlank((String)ticketForUrl)) {
            return ticketForUrl;
        }
        return CookieUtil.getCookie("sso_ticket");
    }

    public static String findDeviceNo() {
        String deviceNo = CookieUtil.getCookie("device_no");
        if (StringUtils.isBlank((String)deviceNo)) {
            deviceNo = remoteSSOService.findDeviceNoByTicket(RequestTool.findTicket());
        }
        return deviceNo;
    }

    public static void outLogin() {
        String ticket = RequestTool.findTicket();
        if (StringUtils.isBlank((String)ticket)) {
            return;
        }
        OutLoginEvent event = new OutLoginEvent();
        event.setTicket(ticket);
        applicationContext.publishEvent((Object)event);
        remoteSSOService.outLogin(ticket);
    }

    public static Boolean isMobile() {
        HttpServletRequest request = RequestTool.get().request;
        return Optional.ofNullable((Boolean)request.getAttribute("mobile")).orElse(false);
    }

    private static RequestParams createRequestParams(HttpServletRequest request) {
        if (request == null) {
            throw new SsoRunTimeException("RequestParams\u89e3\u6790\u65f6\u7684request\u4e0d\u80fd\u4e3a\u7a7a");
        }
        RequestParams rp = new RequestParams();
        Map<String, String> cookieMap = RequestTool.parseCookies(request);
        rp.setUrl(RequestTool.parseUrl(request));
        rp.setCookies(cookieMap);
        rp.setIp(RequestTool.parseIp(request));
        rp.setUri(request.getRequestURI());
        return rp;
    }

    @Autowired
    public void setRemoteAdminService(RemoteAdminService remoteAdminService) {
        RequestTool.remoteAdminService = remoteAdminService;
    }

    @Autowired
    public void setRemoteSSOService(RemoteSSOService remoteSSOService) {
        RequestTool.remoteSSOService = remoteSSOService;
    }

    @Autowired
    public void setApplicationContext(ApplicationContext applicationContext) {
        RequestTool.applicationContext = applicationContext;
    }

    private static String parseUrl(HttpServletRequest request) {
        String queryString;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(RequestTool.parseHomeUrl(request));
        String urlPath = request.getRequestURI();
        if (StringUtils.isNotBlank((String)urlPath) && !StringUtils.equals((String)"/", (String)urlPath)) {
            stringBuilder.append(urlPath);
        }
        if (StringUtils.isNotBlank((String)(queryString = request.getQueryString()))) {
            stringBuilder.append("?").append(queryString);
        }
        return stringBuilder.toString();
    }

    private static String parseHomeUrl(HttpServletRequest request) {
        StringBuilder url = new StringBuilder();
        String scheme = request.getScheme();
        int port = request.getServerPort();
        url.append(scheme);
        url.append("://");
        url.append(request.getServerName());
        if (port == 80 || port == 443 || port <= 0) {
            return url.toString();
        }
        url.append(':');
        url.append(request.getServerPort());
        return url.toString();
    }

    private static Map<String, String> parseCookies(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        HashMap cookieMap = Maps.newHashMap();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                cookieMap.put(cookie.getName(), cookie.getValue());
            }
        }
        return cookieMap;
    }

    public static String parseIp(HttpServletRequest request) {
        return cn.com.duiba.wolf.perf.timeprofile.RequestTool.getIpAddr((HttpServletRequest)request);
    }
}

