/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.web.export;

import cn.com.duiba.sso.api.web.export.BaseExportRunnable;
import cn.com.duiba.sso.api.web.export.ExportFileInfo;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.springframework.context.ApplicationContext;

public class SsoExportFileService {
    @Resource
    private ApplicationContext applicationContext;
    @Resource
    private HazelcastInstance hazelcastInstance;
    @Resource
    private ExecutorService ssoExecutorService;
    private IMap<String, ExportFileInfo> exportFileInfoIMap;

    @PostConstruct
    public void init() {
        this.exportFileInfoIMap = this.hazelcastInstance.getMap("SsoExportFileService.exportFileInfoIMap");
    }

    public ExportFileInfo getExportFileInfo(String taskId) {
        ExportFileInfo info = (ExportFileInfo)this.exportFileInfoIMap.get((Object)taskId);
        if (Objects.isNull(info)) {
            return new ExportFileInfo();
        }
        return info;
    }

    public void publishExportFileInfo(ExportFileInfo info) {
        this.exportFileInfoIMap.put((Object)info.getTaskId(), (Object)info, 5L, TimeUnit.MINUTES);
    }

    public <T extends BaseExportRunnable> T createExportTask(Class<T> teskType) {
        return (T)((BaseExportRunnable)this.applicationContext.getBean(teskType));
    }

    public void runTesk(BaseExportRunnable runnable) {
        runnable.init();
        this.ssoExecutorService.submit(runnable);
    }
}

