/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.web.interceptor.handler.impl;

import cn.com.duiba.application.boot.api.component.environment.Environment;
import cn.com.duiba.application.boot.api.domain.dto.ApplicationDto;
import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.exception.SsoRunTimeException;
import cn.com.duiba.sso.api.service.power.AdminPowerCacheService;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.sso.api.tool.SystemInfo;
import cn.com.duiba.sso.api.web.interceptor.annotation.AuthCanAccess;
import cn.com.duiba.sso.api.web.interceptor.handler.SsoFilterHandler;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Objects;
import java.io.IOException;
import java.lang.reflect.Method;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.method.HandlerMethod;

public class AuthorityFilterHandler
implements SsoFilterHandler {
    @Resource
    private Environment currentEnvironment;
    @Resource
    private AdminPowerCacheService adminPowerCacheService;

    @Override
    public Boolean before(Object handler) {
        if (this.hasAuthCanAccess(handler).booleanValue()) {
            return true;
        }
        ApplicationDto system = SystemInfo.getThisSystemInfo();
        AdminDto admin = RequestTool.getAdmin();
        if (!RequestTool.isMobile().booleanValue() && !admin.getSystemIdSet().contains(system.getId())) {
            this.dontHasPower("\u5c0a\u656c\u7684" + admin.getName() + "\uff0c\u60a8\u6682\u65f6\u6ca1\u6709" + system.getAppName() + "\u7684\u8bbf\u95ee\u6743\u9650");
            return false;
        }
        HttpServletRequest request = RequestTool.getRequest();
        String url = request.getRequestURI();
        if (this.adminPowerCacheService.hasPower(RequestTool.getAdminId(), url).booleanValue()) {
            return true;
        }
        this.dontHasPower("\u65e0\u6743\u8bbf\u95ee");
        return false;
    }

    protected Boolean hasAuthCanAccess(Object handler) {
        if (handler instanceof HandlerMethod) {
            HandlerMethod method = (HandlerMethod)handler;
            AuthCanAccess canAccess = (AuthCanAccess)AnnotationUtils.findAnnotation((Method)method.getMethod(), AuthCanAccess.class);
            return !Objects.equal(null, (Object)canAccess);
        }
        if (!Environment.DEV.equals((Object)this.currentEnvironment)) {
            return false;
        }
        AdminDto admin = RequestTool.getAdmin();
        return StringUtils.equals((String)"swagger@duiba.com.cn", (String)admin.getEmail());
    }

    protected void dontHasPower(String message) {
        String context;
        HttpServletResponse response = RequestTool.getResponse();
        if (RequestTool.isAsynchronousRequests().booleanValue()) {
            JSONObject json = new JSONObject();
            json.put("code", (Object)"SSO:01002");
            json.put("success", (Object)false);
            json.put("desc", (Object)"\u65e0\u6743\u8bbf\u95ee");
            json.put("message", (Object)message);
            response.setHeader("Content-Type", "application/json;charset=UTF-8");
            context = json.toJSONString();
        } else {
            response.setHeader("Content-Type", "text/html;charset=UTF-8");
            context = message;
        }
        try {
            response.getWriter().write(context);
        }
        catch (IOException e) {
            throw new SsoRunTimeException((Throwable)e);
        }
    }

    public int getOrder() {
        return 10;
    }
}

