/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.web.controller;

import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.domain.dto.AdminInfoDto;
import cn.com.duiba.sso.api.remoteservice.RemoteAdminService;
import cn.com.duiba.sso.api.tool.JsonRender;
import cn.com.duiba.sso.api.tool.RequestTool;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sso/admin", "/mobile/sso/admin"})
public class AdminInfoController {
    @Resource
    private RemoteAdminService remoteAdminService;

    @RequestMapping(value={"/adminInfo"}, method={RequestMethod.GET})
    public JsonRender adminInfo() {
        JSONObject model = new JSONObject();
        AdminDto admin = RequestTool.getAdmin();
        model.put("adminId", (Object)admin.getId());
        model.put("adminName", (Object)admin.getName());
        model.put("email", (Object)admin.getEmail());
        model.put("account", (Object)admin.getAccount());
        return JsonRender.successResult(model);
    }

    @RequestMapping(value={"/searchAdminLikeNameOrAccount"}, method={RequestMethod.GET})
    public JsonRender searchAdminLikeNameOrAccount(@RequestParam String search) {
        List adminDtos = this.remoteAdminService.findByNameLike(search);
        JsonRender jsonRender = JsonRender.successResult();
        jsonRender.put("adminList", adminDtos);
        return jsonRender;
    }

    @RequestMapping(value={"/findAdminById"}, method={RequestMethod.GET})
    public AdminInfoDto findAdminById(@RequestParam Long id) {
        return Optional.ofNullable(this.remoteAdminService.findSimpleAdminInfo(id)).orElse(new AdminInfoDto());
    }
}

