/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.service;

import cn.com.duiba.application.boot.api.component.environment.Environment;
import cn.com.duiba.sso.api.service.HostEnvironment;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;

public class HostEnvironmentMapping {
    @Resource
    private Environment currentEnvironment;
    private Map<String, HostEnvironment> mapping = Maps.newHashMap();
    private List<HostEnvironment> relationList = Lists.newArrayList();

    public void addMapping(String host, Environment environment, boolean isPublic) {
        this.addMapping(host, environment, "default", isPublic);
    }

    public void addMapping(String host, Environment environment, String cluster, boolean isPublic) {
        HostEnvironment hostEnvironment = new HostEnvironment(host, environment, cluster);
        this.mapping.put(host, hostEnvironment);
        if (isPublic) {
            this.relationList.add(hostEnvironment);
        }
    }

    public Environment findEnvironmentByHost(String host) {
        if (!this.mapping.containsKey(host)) {
            return this.currentEnvironment;
        }
        HostEnvironment hostEnvironment = this.mapping.get(host);
        return hostEnvironment.getEnvironment();
    }

    public Boolean containsHost(String host) {
        return this.mapping.containsKey(host);
    }

    public List<HostEnvironment> getHostEnvironmentMappings() {
        return Lists.newArrayList(this.relationList);
    }
}

