package cn.com.duiba.sso.api.config;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertiesPropertySource;

import java.util.Properties;

/**
 * 强行打开csrf安全机制
 * @author liuyao
 */
public class SsoWebEnvApplicationInitializer implements EnvironmentPostProcessor {

    @Override
    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        Properties properties = new Properties();
        properties.put("duiba.security.csrf.enable",true);
        PropertiesPropertySource propertiesPropertySource = new PropertiesPropertySource("ssoWebConfig", properties);
        environment.getPropertySources().addLast(propertiesPropertySource);
    }
}
