package cn.com.duiba.sso.api.web.controller;

import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.domain.dto.AdminInfoDto;
import cn.com.duiba.sso.api.remoteservice.RemoteAdminService;
import cn.com.duiba.sso.api.tool.JsonRender;
import cn.com.duiba.sso.api.tool.RequestTool;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * @author liuyao
 */
@RestController
@RequestMapping({"/sso/admin","/mobile/sso/admin"})
public class AdminInfoController {

    @Resource
    private RemoteAdminService remoteAdminService;

    @RequestMapping(value = "/adminInfo",method = RequestMethod.GET)
    public JsonRender adminInfo(){
        JSONObject model = new JSONObject();
        AdminDto admin = RequestTool.getAdmin();
        model.put("adminId",admin.getId());
        model.put("adminName",admin.getName());
        model.put("email",admin.getEmail());
        model.put("account",admin.getAccount());
        return JsonRender.successResult(model);
    }

    @RequestMapping(value = "/searchAdminLikeNameOrAccount",method = RequestMethod.GET)
    public JsonRender searchAdminLikeNameOrAccount(@RequestParam String search){
        List<AdminDto> adminDtos = remoteAdminService.findByNameLike(search);
        List<AdminInfoDto> adminList = Lists.newArrayList();
        for(AdminDto admin:adminDtos){
            AdminInfoDto info = new AdminInfoDto();
            info.setAccount(admin.getAccount());
            info.setId(admin.getId());
            info.setName(admin.getName());
            info.setEnable(true);
            adminList.add(info);
        }
        JsonRender jsonRender = JsonRender.successResult();
        jsonRender.put("adminList",adminList);
        return jsonRender;
    }

    @RequestMapping(value = "/findAdminById",method = RequestMethod.GET)
    public AdminInfoDto findAdminById(@RequestParam Long id){
        return Optional.ofNullable(remoteAdminService.findSimpleAdminInfo(id)).orElse(new AdminInfoDto());
    }

    @RequestMapping(value = "/findAdminByIds",method = RequestMethod.GET)
    public List<AdminInfoDto> findAdminByIds(@RequestParam String ids){
        if(StringUtils.isBlank(ids)){
            return Collections.emptyList();
        }
        Splitter splitter = Splitter.on(",").omitEmptyStrings().trimResults();
        List<Long> adminIds = splitter.splitToList(ids).stream().map(Long::new).collect(Collectors.toList());
        return remoteAdminService.batchFindAdminInfoByIds(adminIds);
    }

}
