package cn.com.duiba.sso.api.web.logger;

import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.domain.dto.LoginStateDto;
import cn.com.duiba.sso.api.service.logger.domain.SsoLoggerMateInfo;
import cn.com.duiba.sso.api.service.logger.service.SsoLoggerMateInfoAdapter;
import cn.com.duiba.sso.api.tool.RequestParams;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.wolf.utils.UUIDUtils;
import org.springframework.stereotype.Component;

/**
 * @author liuyao
 */
@Component
public class DefaultSsoLoggerMateInfoAdapter implements SsoLoggerMateInfoAdapter {

    @Override
    public SsoLoggerMateInfo getLoggerMateInfo() {

        SsoLoggerMateInfo mateInfo = new SsoLoggerMateInfo();
        RequestParams requestParams = RequestTool.getRequestParams();
        LoginStateDto loginState = requestParams.getLoginState();

        if(loginState!=null){
            AdminDto admin = RequestTool.getAdmin();
            mateInfo.setOprName(admin.getName());
            mateInfo.setAdminId(admin.getId());
        }
        mateInfo.setIp(requestParams.getIp());
        mateInfo.setUri(requestParams.getUri());
        mateInfo.setUrl(requestParams.getUrl());
        return mateInfo;
    }

}
