package cn.com.duiba.sso.api;

import cn.com.duiba.sso.api.constants.SsoProperties;
import cn.com.duiba.sso.api.service.HostEnvironmentMapping;
import cn.com.duiba.sso.api.service.SsoUrlService;
import cn.com.duiba.sso.api.service.logger.service.SsoLoggerMateInfoAdapter;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.sso.api.web.export.SsoExportFileConfiguration;
import cn.com.duiba.sso.api.web.interceptor.MobileInterceptor;
import cn.com.duiba.sso.api.web.interceptor.SsoFilterHandlerQueue;
import cn.com.duiba.sso.api.web.interceptor.SsoInterceptor;
import cn.com.duiba.sso.api.web.interceptor.handler.SsoFilterHandler;
import cn.com.duiba.sso.api.web.interceptor.handler.impl.AuthorityFilterHandler;
import cn.com.duiba.sso.api.web.interceptor.handler.impl.LoginFilterHandler;
import cn.com.duiba.sso.api.web.logger.DefaultSsoLoggerMateInfoAdapter;
import cn.com.duiba.sso.api.web.power.AuthorizeInterceptor;
import org.apache.commons.lang.StringUtils;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.Order;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

import javax.annotation.Resource;
import java.util.List;

@ComponentScan("cn.com.duiba.sso.api.web")
@ConditionalOnWebApplication
@AutoConfigureAfter(SsoBasicConfiguration.class)
@EnableConfigurationProperties(SsoProperties.class)
@Import({
        SsoBasicConfiguration.class,
        SsoExportFileConfiguration.class
})
@Order(-1)
public class SsoAutoConfiguration implements WebMvcConfigurer {

    @Resource
    private SsoProperties ssoProperties;
    @Resource
    private ApplicationContext applicationContext;

    /**
     * 初始化RequestTool
     **/
    @Bean
    public RequestTool initRequestTool(){
        return new RequestTool();
    }

    @Bean
    public HostEnvironmentMapping hostEnvironmentMapping(){
        return new HostEnvironmentMapping();
    }

    @Bean
    public SsoUrlService ssoUrlService(){
        return new SsoUrlService();
    }

    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        String pathPatterns = ssoProperties.getPathPatterns();
        String[] paths = StringUtils.split(pathPatterns,",");

        String excludePathPatterns = ssoProperties.getExcludePathPatterns();
        String[] excludePath = StringUtils.isEmpty(excludePathPatterns) ? new String[]{} : StringUtils.split(excludePathPatterns,",");

        String mobilePathPatterns = ssoProperties.getMobilePathPatterns();
        String[] mobilePaths = StringUtils.split(mobilePathPatterns,",");

        MobileInterceptor mobileInterceptor = new MobileInterceptor();
        registry.addInterceptor(mobileInterceptor)
                .addPathPatterns(mobilePaths);

        SsoInterceptor ssoInterceptor = applicationContext.getBean(SsoInterceptor.class);
        registry.addInterceptor(ssoInterceptor)
                .addPathPatterns(paths)
                .addPathPatterns("/auth/**")
                .addPathPatterns("/sso/**")//sso内置开放接口
                .excludePathPatterns(excludePath);//排除移动端的链接
    }

    @Bean
    @ConditionalOnMissingBean
    public SsoInterceptor ssoInterceptor(List<SsoFilterHandler> ssoFilterHandlers){
        SsoFilterHandlerQueue queue = new SsoFilterHandlerQueue();
        SsoInterceptor ssoInterceptor = new SsoInterceptor();
        for (SsoFilterHandler handler:ssoFilterHandlers) {
            queue.addHandler(handler);
        }
        ssoInterceptor.setHandleQueue(queue);
        return ssoInterceptor;
    }

    @Bean
    @ConditionalOnMissingBean
    public SsoLoggerMateInfoAdapter ssoLoggerMateInfoAdapter(){
        return new DefaultSsoLoggerMateInfoAdapter();
    }

    @Bean
    @ConditionalOnMissingBean
    public LoginFilterHandler loginFilterHandler(){
        return new LoginFilterHandler();
    }

    @Bean
    @ConditionalOnMissingBean
    public AuthorityFilterHandler authorityFilterHandler(){
        return new AuthorityFilterHandler();
    }

    @Bean
    public AuthorizeInterceptor authorizeInterceptor(){
        return new AuthorizeInterceptor();
    }


}
