package cn.com.duiba.sso.api.constants;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * @author liuyao
 */
@Data
@ConfigurationProperties(prefix = "duiba.sso")
public class SsoProperties {

    /**
     * 一级path
     */
    private String rootPath = "";
    /**
     * 登录成功后默认的跳转地址，一般为首页地址
     */
    private String defaultRedirectUrl = "/";
    /**
     * sso要拦截的url，配置多个地址用","分隔
     * 若没配置，就采用默认值/** 拦截所有
     */
    private String pathPatterns = "/**";
    /**
     * 移动端拦截地址
     */
    private String mobilePathPatterns = "/mobile**/**";
    /**
     * 排除的路径，sso不拦截
     */
    private String excludePathPatterns;
    /**
     * 移动端默认跳转地址
     */
    private String mobileDefaultRedirectUrl = "/mobile/index";
    /**
     * 是否忽略应用访问权限的校验
     */
    private Boolean canDirectAccess = false;

}

