package cn.com.duiba.sso.api.web.export;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.map.IMap;
import org.springframework.context.ApplicationContext;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

/**
 * @author liuyao
 */
public class SsoExportFileService{

    @Resource
    private ApplicationContext applicationContext;
    @Resource
    private HazelcastInstance hazelcastInstance;
    @Resource
    private ExecutorService ssoExecutorService;

    private IMap<String,ExportFileInfo> exportFileInfoIMap;

    @PostConstruct
    public void init(){
        exportFileInfoIMap = hazelcastInstance.getMap("SsoExportFileService.exportFileInfoIMap");
    }

    public ExportFileInfo getExportFileInfo(String taskId){
        ExportFileInfo info =  exportFileInfoIMap.get(taskId);
        if(Objects.isNull(info)){
            return new ExportFileInfo();
        }
        return info;
    }

    public void publishExportFileInfo(ExportFileInfo info){
        exportFileInfoIMap.put(info.getTaskId(),info,5, TimeUnit.MINUTES);
    }

    public <T extends BaseExportRunnable> T createExportTask(Class<T> teskType){
        return applicationContext.getBean(teskType);
    }

    public void runTesk(BaseExportRunnable runnable){
        runnable.init();
        ssoExecutorService.submit(runnable);
    }


}
