package cn.com.duiba.sso.api.web.power;

import cn.com.duiba.sso.api.exception.SsoRunTimeException;
import cn.com.duiba.sso.api.service.power.SsoResourceFieldFilter;
import cn.com.duiba.sso.api.tool.RequestTool;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.context.ApplicationContext;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

import javax.annotation.Resource;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Objects;


/**
 * @author liuyao
 */
@Aspect
public class AuthorizeInterceptor {

    @Resource
    private ApplicationContext applicationContext;
    @Resource
    private SsoResourceFieldFilter ssoResourceFieldFilter;

    private final ExpressionParser parser = new SpelExpressionParser();

    private final LocalVariableTableParameterNameDiscoverer discoverer = new LocalVariableTableParameterNameDiscoverer();

    @Around("@annotation(PreAuthorize)")
    public Object preProcessQueryPattern(ProceedingJoinPoint point) throws Throwable {

        Object[] arguments = point.getArgs();
        MethodSignature signature = (MethodSignature) point.getSignature();
        Method method = signature.getMethod();

        PreAuthorize preAuthorize = AnnotationUtils.findAnnotation(method, PreAuthorize.class);
        String[] paramNames = discoverer.getParameterNames(method);
        Objects.requireNonNull(preAuthorize);
        Objects.requireNonNull(paramNames);
        for(String express:preAuthorize.value()){
            Expression expression = parser.parseExpression(express);
            StandardEvaluationContext context = new StandardEvaluationContext();
            for (int i = 0; i < arguments.length; i++) {
                context.setVariable(paramNames[i], arguments[i]);
            }
            context.setBeanResolver(new BeanFactoryResolver(applicationContext));

            expression.getValue(context, Void.class);
        }
        return point.proceed();
    }

    @AfterReturning(value = "@annotation(cn.com.duiba.sso.api.web.power.SsoResourceFieldAuthorize)",returning = "collection")
    public void ssoContentPreAuthorize(Collection<?> collection) {
        Long adminId = RequestTool.getAdminId();
        if(Objects.isNull(adminId)){
            throw new SsoRunTimeException("无法获取到当前用户");
        }
        ssoResourceFieldFilter.doFilter(adminId,collection);
    }


}
