/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.web.controller;

import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.domain.dto.AdminInfoDto;
import cn.com.duiba.sso.api.remoteservice.RemoteAdminService;
import cn.com.duiba.sso.api.tool.JsonRender;
import cn.com.duiba.sso.api.tool.RequestTool;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sso/admin", "/mobile/sso/admin"})
public class AdminInfoController {
    @Resource
    private RemoteAdminService remoteAdminService;

    @RequestMapping(value={"/adminInfo"}, method={RequestMethod.GET})
    public JsonRender adminInfo() {
        JSONObject model = new JSONObject();
        AdminDto admin = RequestTool.getAdmin();
        model.put("adminId", (Object)admin.getId());
        model.put("adminName", (Object)admin.getName());
        model.put("email", (Object)admin.getEmail());
        model.put("account", (Object)admin.getAccount());
        return JsonRender.successResult(model);
    }

    @RequestMapping(value={"/searchAdminLikeNameOrAccount"}, method={RequestMethod.GET})
    public JsonRender searchAdminLikeNameOrAccount(@RequestParam String search) {
        List adminDtos = this.remoteAdminService.findByNameLike(search);
        ArrayList adminList = Lists.newArrayList();
        for (AdminDto admin : adminDtos) {
            AdminInfoDto info = new AdminInfoDto();
            info.setAccount(admin.getAccount());
            info.setId(admin.getId());
            info.setName(admin.getName());
            info.setEnable(Boolean.valueOf(true));
            adminList.add(info);
        }
        JsonRender jsonRender = JsonRender.successResult();
        jsonRender.put("adminList", adminList);
        return jsonRender;
    }

    @RequestMapping(value={"/findAdminById"}, method={RequestMethod.GET})
    public AdminInfoDto findAdminById(@RequestParam Long id) {
        return Optional.ofNullable(this.remoteAdminService.findSimpleAdminInfo(id)).orElse(new AdminInfoDto());
    }

    @RequestMapping(value={"/findAdminByIds"}, method={RequestMethod.GET})
    public List<AdminInfoDto> findAdminByIds(@RequestParam String ids) {
        if (StringUtils.isBlank((CharSequence)ids)) {
            return Collections.emptyList();
        }
        Splitter splitter = Splitter.on((String)",").omitEmptyStrings().trimResults();
        List adminIds = splitter.splitToList((CharSequence)ids).stream().map(Long::new).collect(Collectors.toList());
        return this.remoteAdminService.batchFindAdminInfoByIds(adminIds);
    }
}

