/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.web.controller;

import cn.com.duiba.application.boot.api.component.environment.RequestEnvironmentDecisionMaker;
import cn.com.duiba.application.boot.api.domain.dto.ApplicationDto;
import cn.com.duiba.sso.api.constants.SsoProperties;
import cn.com.duiba.sso.api.domain.dto.LoginStateDto;
import cn.com.duiba.sso.api.exception.SsoException;
import cn.com.duiba.sso.api.remoteservice.RemoteSSOService;
import cn.com.duiba.sso.api.tool.CookieUtil;
import cn.com.duiba.sso.api.tool.JsonRender;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.sso.api.tool.SystemInfo;
import cn.com.duiba.sso.api.web.interceptor.annotation.CanAccess;
import cn.com.duibaboot.ext.autoconfigure.web.login.LoginSuccessEvent;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/mobile/sso", "/sso"})
public class SsoController {
    private static final Logger log = LoggerFactory.getLogger(SsoController.class);
    @Resource
    private RemoteSSOService remoteSSOService;
    @Resource
    private SsoProperties properties;
    @Resource
    private ApplicationContext applicationContext;
    @Resource
    private RequestEnvironmentDecisionMaker requestEnvironmentDecisionMaker;

    @CanAccess
    @RequestMapping(value={"/ssoIndex"})
    public String ssoIndex(@RequestParam Long ssoStamp, @RequestParam(required=false) String redirect) throws SsoException {
        Long systemId = SystemInfo.getThisSystemId();
        String ticket = this.remoteSSOService.findTicketByStamp(systemId, ssoStamp);
        if (StringUtils.isBlank((String)ticket)) {
            throw new SsoException("\u83b7\u53d6SSO\u901a\u884c\u8bc1\u5931\u8d25");
        }
        LoginStateDto loginState = this.remoteSSOService.verifyTicket(ticket);
        if (loginState == null) {
            throw new SsoException("ticket\u5931\u6548");
        }
        RequestTool.setLoginState(loginState);
        CookieUtil.setLoginCookie(ticket);
        String deviceNo = RequestTool.findDeviceNo();
        if (StringUtils.isNotBlank((String)deviceNo)) {
            CookieUtil.setCookie("device_no", deviceNo, 473040000);
        }
        LoginSuccessEvent event = new LoginSuccessEvent();
        event.setSession((Object)loginState);
        event.setRequest(RequestTool.getRequest());
        event.setResponse(RequestTool.getResponse());
        event.setExpirationTime(loginState.getLoginTimeout());
        this.applicationContext.publishEvent((Object)event);
        return "redirect:" + Optional.ofNullable(redirect).orElse(this.properties.getDefaultRedirectUrl());
    }

    @CanAccess
    @ResponseBody
    @RequestMapping(value={"/systemInfo"})
    public JsonRender systemInfo() {
        JsonRender render = JsonRender.successResult();
        render.put("ssoHomeURL", this.remoteSSOService.findSsoHomeUrl());
        ApplicationDto systemDto = SystemInfo.getThisSystemInfo();
        render.put("system", systemDto);
        render.put("environment", this.requestEnvironmentDecisionMaker.getRequestEnvironment().getEnvId());
        return render;
    }

    @ResponseBody
    @RequestMapping(value={"/outLogin"})
    public JsonRender outLogin() {
        RequestTool.outLogin();
        return JsonRender.successResult();
    }
}

