/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.web.interceptor.handler.impl;

import cn.com.duiba.application.boot.api.component.environment.Environment;
import cn.com.duiba.application.boot.api.domain.dto.ApplicationDto;
import cn.com.duiba.sso.api.constants.SsoProperties;
import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.exception.SsoRunTimeException;
import cn.com.duiba.sso.api.remoteservice.RemotePermissionService;
import cn.com.duiba.sso.api.service.power.AdminPowerCacheService;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.sso.api.tool.SystemInfo;
import cn.com.duiba.sso.api.web.interceptor.annotation.AuthCanAccess;
import cn.com.duiba.sso.api.web.interceptor.handler.SsoFilterHandler;
import com.alibaba.fastjson.JSONObject;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.method.HandlerMethod;

public class AuthorityFilterHandler
implements SsoFilterHandler {
    @Resource
    private Environment currentEnvironment;
    @Resource
    private AdminPowerCacheService adminPowerCacheService;
    @Resource
    private SsoProperties ssoProperties;
    @Resource
    private RemotePermissionService remotePermissionService;
    private final LoadingCache<Long, Boolean> canAccessCache = Caffeine.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<Long, Boolean>(){

        public @Nullable Boolean load(@NonNull Long adminId) {
            return AuthorityFilterHandler.this.remotePermissionService.canAccessSystem(SystemInfo.getSystemAlias(), adminId);
        }
    });

    @Override
    public Boolean before(Object handler) {
        if (this.hasAuthCanAccess(handler).booleanValue()) {
            return true;
        }
        ApplicationDto system = SystemInfo.getThisSystemInfo();
        Long adminId = RequestTool.getAdminId();
        if (!(RequestTool.isMobile().booleanValue() || this.ssoProperties.getCanDirectAccess().booleanValue() || Objects.requireNonNull((Boolean)this.canAccessCache.get((Object)adminId)).booleanValue())) {
            AdminDto admin = RequestTool.getAdmin();
            this.dontHasPower("\u5c0a\u656c\u7684" + admin.getName() + "\uff0c\u60a8\u6682\u65f6\u6ca1\u6709" + system.getAppName() + "\u7684\u8bbf\u95ee\u6743\u9650");
            return false;
        }
        HttpServletRequest request = RequestTool.getRequest();
        String url = request.getRequestURI();
        if (this.adminPowerCacheService.hasPower(RequestTool.getAdminId(), url).booleanValue()) {
            return true;
        }
        this.dontHasPower("\u65e0\u6743\u8bbf\u95ee");
        return false;
    }

    protected Boolean hasAuthCanAccess(Object handler) {
        HandlerMethod method;
        AuthCanAccess canAccess;
        if (handler instanceof HandlerMethod && Objects.nonNull(canAccess = (AuthCanAccess)AnnotationUtils.findAnnotation((Method)(method = (HandlerMethod)handler).getMethod(), AuthCanAccess.class))) {
            return true;
        }
        Long adminId = RequestTool.getAdminId();
        return Environment.DEV.equals((Object)this.currentEnvironment) && Objects.equals(2219L, adminId);
    }

    protected void dontHasPower(String message) {
        String context;
        HttpServletResponse response = RequestTool.getResponse();
        if (RequestTool.isAsynchronousRequests().booleanValue()) {
            JSONObject json = new JSONObject();
            json.put("code", (Object)"SSO:01002");
            json.put("success", (Object)false);
            json.put("desc", (Object)"\u65e0\u6743\u8bbf\u95ee");
            json.put("message", (Object)message);
            response.setHeader("Content-Type", "application/json;charset=UTF-8");
            context = json.toJSONString();
        } else {
            response.setHeader("Content-Type", "text/html;charset=UTF-8");
            context = message;
        }
        try {
            response.getWriter().write(context);
        }
        catch (IOException e) {
            throw new SsoRunTimeException((Throwable)e);
        }
    }

    public int getOrder() {
        return 10;
    }
}

