/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.common.tree;

import cn.com.duiba.sso.api.common.tree.Tree;
import cn.com.duiba.sso.api.common.tree.TreeNodeShim;
import cn.com.duiba.sso.api.common.tree.TreeView;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;

public class TreeFactory {
    public static <T extends TreeNodeShim> Tree<T> createTree(List<T> entreList) {
        LinkedList cache = Lists.newLinkedList();
        Tree<TreeNodeShim> tree = new Tree<TreeNodeShim>();
        cache.addAll(entreList);
        try {
            int size = cache.size();
            while (size != 0) {
                ListIterator items = cache.listIterator();
                while (items.hasNext()) {
                    TreeNodeShim node = (TreeNodeShim)items.next();
                    if (!tree.containsId(node.getParentId())) continue;
                    tree.addNode(node);
                    items.remove();
                }
                if (cache.size() == size) {
                    throw new RuntimeException("\u521b\u5efa\u6811\u65f6\uff0c\u5b58\u5728\u65e0\u7236\u8282\u70b9\u7684\u5b50\u8282\u70b9");
                }
                size = cache.size();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u6570\u636e\u5e93\u4e2d\u7236\u5b50\u5173\u7cfb\u5f02\u5e38");
        }
        return tree;
    }

    public static <T extends TreeView<T>> List<T> transformTree(Tree<T> tree) {
        if (tree.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList viewList = Lists.newArrayList();
        List<T> list = tree.getTreeView();
        Stack<TreeView> stack = new Stack<TreeView>();
        for (TreeView item : list) {
            if (stack.isEmpty()) {
                stack.push(item);
                continue;
            }
            TreeView top = (TreeView)stack.peek();
            if (top.getLevel() < item.getLevel()) {
                if (item.getLevel() - top.getLevel() == 1L) {
                    top.addChild(item);
                    continue;
                }
                List childs = top.getChild();
                stack.push((TreeView)childs.get(childs.size() - 1));
                ((TreeView)stack.peek()).addChild(item);
                continue;
            }
            if (Objects.equal((Object)top.getLevel(), (Object)item.getLevel())) {
                TreeView ytop = (TreeView)stack.pop();
                if (ytop.getLevel() == 1L) {
                    viewList.add(ytop);
                } else {
                    ((TreeView)stack.peek()).addChild(item);
                }
                stack.push(item);
                continue;
            }
            if (top.getLevel() <= item.getLevel()) continue;
            long levelDifference = top.getLevel() - item.getLevel();
            int i = 0;
            while ((long)i <= levelDifference) {
                TreeView sackItem = (TreeView)stack.pop();
                if (sackItem.getLevel() == 1L) {
                    viewList.add(sackItem);
                }
                ++i;
            }
            stack.push(item);
        }
        viewList.add(stack.pop());
        return viewList;
    }
}

