/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.tool;

import cn.com.duiba.sso.api.domain.dto.SystemDto;
import cn.com.duiba.sso.api.domain.event.SystemInfoInitComplateEvent;
import cn.com.duiba.sso.api.domain.properties.SpringApplicationProperties;
import cn.com.duiba.sso.api.exception.SsoRunTimeException;
import cn.com.duiba.sso.api.remoteservice.RemoteSystemService;
import cn.com.duiba.sso.api.service.eventbus.SsoEventBus;
import com.google.common.base.Optional;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SystemInfo {
    private Logger logger = LoggerFactory.getLogger(SystemInfo.class);
    private static RemoteSystemService remoteSystemService;
    private static volatile String systemAlias;
    private static Cache<String, SystemDto> CACHE;
    @Autowired
    private SsoEventBus eventBus;
    @Autowired
    private SpringApplicationProperties springApplicationProperties;

    @Autowired
    public void setRemoteSystemService(RemoteSystemService remoteSystemService) {
        SystemInfo.remoteSystemService = remoteSystemService;
    }

    @PostConstruct
    private void init() {
        systemAlias = (String)Optional.fromNullable((Object)this.springApplicationProperties.getPriorName()).or((Object)this.springApplicationProperties.getName());
        if (StringUtils.isBlank((CharSequence)systemAlias)) {
            throw new SsoRunTimeException("Sso\u5ba2\u6237\u7aef\u542f\u52a8\u5931\u8d25\uff0c\u8bf7\u914d\u7f6e spring.application.name \u7cfb\u7edf\u522b\u540d");
        }
        System.out.println("Sso\u83b7\u53d6\u7cfb\u7edf\u4fe1\u606f\u6210\u529f\uff0c\u7cfb\u7edf\u521d\u59cb\u5316\u4e8b\u4ef6 SystemInfoInitComplateEvent \u5df2\u7ecf\u53d1\u51fa");
        this.logger.info("Sso\u83b7\u53d6\u7cfb\u7edf\u4fe1\u606f\u6210\u529f\uff0c\u7cfb\u7edf\u521d\u59cb\u5316\u4e8b\u4ef6 SystemInfoInitComplateEvent \u5df2\u7ecf\u53d1\u51fa");
        SystemInfoInitComplateEvent event = new SystemInfoInitComplateEvent();
        event.setSystemDto(SystemInfo.getThisSystemInfo());
        this.eventBus.post(event);
    }

    public static String getThisSystemAlias() {
        return systemAlias;
    }

    public static SystemDto getThisSystemInfo() {
        try {
            return (SystemDto)CACHE.get((Object)systemAlias, () -> remoteSystemService.getSystemByAlias(systemAlias));
        }
        catch (Exception e) {
            throw new SsoRunTimeException("\u672a\u627e\u5230" + systemAlias + "\u5bf9\u5e94\u7684\u7cfb\u7edf\u914d\u7f6e");
        }
    }

    public static Long getThisSystemId() {
        return SystemInfo.getThisSystemInfo().getId();
    }

    static {
        CACHE = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build();
    }
}

