package cn.com.duiba.sso.api.domain.bizenum;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;

import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.stream.Collectors;

/**
 * Created by liuyao on 2017/5/15.
 */
public enum CacheKeyEnum {

    TICKET_FOR_ADMINID("TICKET_ADMIN_ID","全局登录通行令牌,缓存的是通行证中的Code"),
    GOOGLE_CODE_FOR_ADMINID("GOOGLE_CODE_FOR_ADMINID","谷歌验证码秘钥"),

    SSO_ADMIN_POWER_CONFIG_VERSION("SSO_POWER_CONFIG_VERSION","管理员权限配置版本"),
    SSO_POWER_TREE_VERSION("SSO_POWER_TREE_VERSION","权限树版本号");

    private static Joiner joiner = Joiner.on("_").skipNulls();

    CacheKeyEnum(String preKey,String description){
        this.preKey = preKey;
        this.description = description;
    }

    private String preKey;
    private String description;

    public String getPreKey() {
        return preKey;
    }

    public void setPreKey(String preKey) {
        this.preKey = preKey;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCacheKey(Object ...bizId){
        List<String> bizIds = Lists.newArrayList(this.preKey);
        for(Object biz:bizId){
            bizIds.add(biz.toString());
        }
        return joiner.join(bizIds);
    }

}
