package cn.com.duiba.sso.api.tool;

import cn.com.duiba.sso.api.service.eventbus.SsoEventBus;
import cn.com.duiba.sso.api.domain.dto.SystemDto;
import cn.com.duiba.sso.api.exception.SsoRunTimeException;
import cn.com.duiba.sso.api.remoteservice.RemoteSystemService;
import com.google.common.base.Optional;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import cn.com.duiba.sso.api.domain.properties.SpringApplicationProperties;

import javax.annotation.PostConstruct;
import java.util.concurrent.TimeUnit;

/**
 * Created by liuyao on 2017/12/5.
 * 本系统的Mate信息
 */
public class SystemInfo {

    private Logger logger = LoggerFactory.getLogger(SystemInfo.class);

    private static RemoteSystemService remoteSystemService;

    private static volatile String systemAlias;

    private static Cache<String,SystemDto> CACHE = CacheBuilder.newBuilder().expireAfterWrite(1, TimeUnit.MINUTES).build();

    @Autowired
    public void setRemoteSystemService(RemoteSystemService remoteSystemService) {
        SystemInfo.remoteSystemService = remoteSystemService;
    }

    @Autowired
    private SpringApplicationProperties springApplicationProperties;

    @PostConstruct
    private void init(){
        SystemInfo.systemAlias = Optional.fromNullable(springApplicationProperties.getPriorName()).or(springApplicationProperties.getName());
        if (StringUtils.isBlank(SystemInfo.systemAlias)){
            throw new SsoRunTimeException("Sso客户端启动失败，请配置 spring.application.name 系统别名");
        }
    }

    /**
     * 获取系统别名
     * @return
     */
    public static String getThisSystemAlias(){
        return systemAlias;
    }

    /**
     * 获取本系统的信息
     * @return
     */
    public static SystemDto getThisSystemInfo(){
        try{
            return CACHE.get(SystemInfo.systemAlias,()->{
                return remoteSystemService.getSystemByAlias(SystemInfo.systemAlias);
            });
        }catch (Exception e){
            throw new SsoRunTimeException("未找到"+systemAlias+"对应的系统配置");
        }
    }

    /**
     * 获取本系统的Id
     * @return
     */
    public static Long getThisSystemId(){
        return getThisSystemInfo().getId();
    }
}
