package cn.com.duiba.sso.api.service.logger.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Created by liuyao on 2017/6/19.
 * SsoLogger注解,主要规定日志的模板和指定日志的编组
 * 不支持日志嵌套,如果存在嵌套,以最外层SsoLogger配置为准
 */
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
public @interface SsoLoggerMethod {
    /**
     * 日志模板
     * 在模板中可以直接使用的参数${adminId}、${adminName}
     * @return
     */
    public String value() default "";

    public String group() default "默认";

}
