package cn.com.duiba.sso.api.service.power;

import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.remoteservice.RemoteAdminService;
import cn.com.duiba.sso.api.tool.SystemInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.List;
import java.util.Set;

@Service
public class AdminPowerService {
    @Autowired
    private PowerTreeService powerTreeService;
    @Autowired
    private RemoteAdminService remoteAdminService;

    /**
     * 查询拥有某个权限的所有有效角色
     * @param powerPath
     * @return
     */
    public List<AdminDto> getHasPowerAdmins(String powerPath){
        Set<Long> pawerIds =  powerTreeService.getPowerIdsByUrl(powerPath);
        if(pawerIds.isEmpty()){
            return Collections.emptyList();
        }
        return remoteAdminService.findAdminsByPowerIds(SystemInfo.getThisSystemId(),pawerIds);
    }

}
