/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.tool.threadpool;

import cn.com.duiba.sso.api.tool.threadpool.AbortPolicyWithReport;
import cn.com.duiba.sso.api.tool.threadpool.NameThreadFactory;
import cn.com.duiba.sso.api.tool.threadpool.ThreadPoolProperties;
import com.google.common.collect.Maps;
import java.util.AbstractQueue;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.stereotype.Component;

@Component
public class ThreadPoolBuilder
implements DisposableBean {
    private static Map<String, ExecutorService> threadPoolCacheMap = Maps.newConcurrentMap();
    protected static final Logger logger = LoggerFactory.getLogger(ThreadPoolBuilder.class);
    private long shutdownTimeout = 3000L;

    public static ExecutorService build(ThreadPoolProperties properties) {
        if (threadPoolCacheMap.containsKey(properties.getThreadName())) {
            return threadPoolCacheMap.get(properties.getThreadName());
        }
        int queueSize = properties.getQueueSize();
        AbstractQueue queue = queueSize <= 0 ? new SynchronousQueue() : new ArrayBlockingQueue(queueSize);
        int maxSize = Math.max(properties.getMaxSize(), properties.getCoreSize());
        ThreadPoolExecutor threadPool = new ThreadPoolExecutor(properties.getCoreSize(), maxSize, 60L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)((Object)queue), new NameThreadFactory(properties.getThreadName()), new AbortPolicyWithReport());
        threadPoolCacheMap.put(properties.getThreadName(), threadPool);
        return threadPool;
    }

    public void destroy() throws Exception {
        Set<String> threadNameSet = threadPoolCacheMap.keySet();
        if (threadNameSet.isEmpty()) {
            return;
        }
        ExecutorService threadPool = ThreadPoolBuilder.build(new ThreadPoolProperties());
        CountDownLatch latch = new CountDownLatch(threadPoolCacheMap.size() - 1);
        for (String name : threadNameSet) {
            if (StringUtils.equals((String)name, (String)"DEFAULT")) continue;
            ExecutorService pool = threadPoolCacheMap.get(name);
            ShutdownThreadPoolTask task = new ShutdownThreadPoolTask(pool, latch);
            threadPool.submit(task);
        }
        latch.await();
        ShutdownThreadPoolTask task = new ShutdownThreadPoolTask(threadPool, null);
        Runtime.getRuntime().addShutdownHook(new Thread(task));
    }

    private class ShutdownThreadPoolTask
    implements Runnable {
        private ExecutorService executorService;
        private CountDownLatch latch;

        public ShutdownThreadPoolTask(ExecutorService executorService, CountDownLatch latch) {
            this.executorService = executorService;
            this.latch = latch;
        }

        @Override
        public void run() {
            try {
                this.executorService.shutdown();
                try {
                    this.executorService.awaitTermination(ThreadPoolBuilder.this.shutdownTimeout, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    logger.info("", (Throwable)e);
                    logger.warn("\u7ebf\u7a0b\u6c60\u8d85\u8fc7{}ms\u4ecd\u672a\u5173\u95ed\uff0c\u5f3a\u5236\u5173\u95ed\u3002", (Object)ThreadPoolBuilder.this.shutdownTimeout);
                }
                if (!this.executorService.isShutdown()) {
                    this.executorService.shutdownNow();
                }
            }
            finally {
                if (this.latch != null) {
                    this.latch.countDown();
                }
            }
        }
    }
}

