package cn.com.duiba.sso.api.service.logger.runnable;

import cn.com.duiba.sso.api.domain.params.SsoLogParams;
import cn.com.duiba.sso.api.remoteservice.RemoteManagerLogService;
import cn.com.duiba.sso.api.service.logger.domain.SsoLoggerMateInfo;
import cn.com.duiba.sso.api.service.logger.domain.SsoLoggerTheadContext;
import cn.com.duiba.sso.api.tool.SystemInfo;
import com.alibaba.fastjson.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Created by liuyao on 2017/6/19.
 * 异步打印日志
 */
public class SsoLoggerRunnable implements Runnable {

    private static Logger logger = LoggerFactory.getLogger(SsoLoggerRunnable.class);

    private SsoLoggerTheadContext context;

    private SsoLoggerMateInfo mateInfo;

    private RemoteManagerLogService remoteManagerLogService;

    @Override
    public void run() {

        List<JSONObject> paramsList = context.getParams();
        for(JSONObject log:paramsList){
            try{
                JSONObject model = new JSONObject();
                model.put("oprName",mateInfo.getOprName());
                model.put("adminName",mateInfo.getOprName());//兼容老版本
                model.putAll(log);

                String logContext = replaceArgs(context.getTemplate(),model);
                SsoLogParams params = new SsoLogParams();
                params.setOprName(mateInfo.getOprName());
                params.setGroup(context.getGroup());
                params.setSystemId(SystemInfo.getThisSystemId());
                params.setIp(mateInfo.getIp());
                params.setParamsJson(log);
                params.setLogContent(logContext);
                remoteManagerLogService.ssoLog(params);
            }catch (Exception e){
                logger.error("操作日志打印失败",e);
            }

        }
    }

    /**
     * 替换模板变量
     * @param template
     * @param data
     * @return
     */
    private String replaceArgs(final String template, JSONObject data){
        // sb用来存储替换过的内容，它会把多次处理过的字符串按源字符串序 存储起来。
        StringBuffer sb = new StringBuffer();
        try{
            Pattern pattern = Pattern.compile("\\$\\{(.+?)\\}");
            Matcher matcher = pattern.matcher(template);
            while(matcher.find()){
                String name = matcher.group(1);// 键名
                String value = "";// 键值
                if(data.containsKey(name)){
                    value = data.getString(name);// 键值
                    value = value.replaceAll("\\$", "\\\\\\$");
                }
                matcher.appendReplacement(sb, value);
            }
            matcher.appendTail(sb);
        }catch(Exception e){
            logger.error("管理员操作日志渲染失败",e);
        }
        return sb.toString();
    }

    public SsoLoggerTheadContext getContext() {
        return context;
    }

    public void setContext(SsoLoggerTheadContext context) {
        this.context = context;
    }

    public SsoLoggerMateInfo getMateInfo() {
        return mateInfo;
    }

    public void setMateInfo(SsoLoggerMateInfo mateInfo) {
        this.mateInfo = mateInfo;
    }

    public void setRemoteManagerLogService(RemoteManagerLogService remoteManagerLogService) {
        this.remoteManagerLogService = remoteManagerLogService;
    }
}
