package cn.com.duiba.sso.api.tool.threadpool;

/**
 * Created by liuyao on 2017/8/12.
 */
public class ThreadPoolProperties {

    public static final String DEFAULT_THREAD_NAME = "DEFAULT";

    //给线程命名,并以此来做线程隔离的依据
    private String threadName = DEFAULT_THREAD_NAME;
    /**
     * 线程池核心大小，默认2
     */
    private int coreSize = 2;
    /**
     * 线程池最大线程数，默认20
     */
    private int maxSize = 20;
    /**
     * Queue的最大容量，默认500，如果为0则使用SynchronousQueue，否则使用ArrayBlockingQueue
     */
    private int queueSize = 500;

    public String getThreadName() {
        return threadName;
    }

    public void setThreadName(String threadName) {
        this.threadName = threadName;
    }

    public int getCoreSize() {
        return coreSize;
    }

    public void setCoreSize(int coreSize) {
        this.coreSize = coreSize;
    }

    public int getMaxSize() {
        return maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public int getQueueSize() {
        return queueSize;
    }

    public void setQueueSize(int queueSize) {
        this.queueSize = queueSize;
    }
}
