/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.tool.threadpool;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class NameThreadFactory
implements ThreadFactory {
    private static final AtomicInteger THREAD_NUM = new AtomicInteger(1);
    private static final String THREAD_NAME_SEPARATOR = "-";
    private Boolean daemo = false;
    private String prefix;
    private ThreadGroup threadGroup;

    public NameThreadFactory(String prefix) {
        this(prefix, false);
    }

    public NameThreadFactory(String prefix, Boolean daemo) {
        this.daemo = daemo;
        this.prefix = prefix;
        SecurityManager securityManager = System.getSecurityManager();
        this.threadGroup = securityManager == null ? Thread.currentThread().getThreadGroup() : securityManager.getThreadGroup();
    }

    @Override
    public Thread newThread(Runnable runnable) {
        String name = this.buildThreadName();
        Thread thread = new Thread(this.threadGroup, runnable, name, 0L);
        thread.setDaemon(this.daemo);
        return thread;
    }

    private String buildThreadName() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.prefix).append(THREAD_NAME_SEPARATOR).append(THREAD_NUM.getAndIncrement());
        return sb.toString();
    }
}

