package cn.com.duiba.sso.api.service.logger.runnable;

import cn.com.duiba.sso.api.domain.dto.SystemDto;
import cn.com.duiba.sso.api.remoteservice.RemoteManagerLogService;
import cn.com.duiba.sso.api.service.logger.domain.AccessLog;
import cn.com.duiba.sso.api.service.logger.domain.SsoLoggerMateInfo;
import cn.com.duiba.sso.api.tool.SystemInfo;

import java.text.SimpleDateFormat;
import java.util.Date;

public class AccessLoggerRunnable implements Runnable {

    private RemoteManagerLogService remoteManagerLogService;

    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    private String requestFunction;

    private Long adminId;

    private SsoLoggerMateInfo mateInfo;

    public Long getAdminId() {
        return adminId;
    }

    public void setAdminId(Long adminId) {
        this.adminId = adminId;
    }

    public SsoLoggerMateInfo getMateInfo() {
        return mateInfo;
    }

    public void setMateInfo(SsoLoggerMateInfo mateInfo) {
        this.mateInfo = mateInfo;
    }

    @Override
    public void run() {
        if(mateInfo==null){
            return;
        }
        SystemDto thisSystem = SystemInfo.getThisSystemInfo();

        AccessLog accessLog = new AccessLog();
        accessLog.setAccessUser(mateInfo.getOprName());
        accessLog.setRequestUrl(mateInfo.getUrl());
        accessLog.setRequestUri(mateInfo.getUri());
        accessLog.setIp(mateInfo.getIp());
        accessLog.setSystemId(thisSystem.getId());
        accessLog.setBusinessSystem(thisSystem.getAppName());
        accessLog.setAccessTime(sdf.format(new Date()));
        accessLog.setRequestFunction(requestFunction);
        remoteManagerLogService.appendAccessLog(accessLog);
    }

    public void setRequestFunction(String requestFunction) {
        this.requestFunction = requestFunction;
    }

    public void setRemoteManagerLogService(RemoteManagerLogService remoteManagerLogService) {
        this.remoteManagerLogService = remoteManagerLogService;
    }
}
