/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.service.export;

import cn.com.duiba.sso.api.service.export.SsoExportFileService;
import com.google.common.base.Joiner;
import java.io.File;
import java.util.Date;
import java.util.Objects;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
public abstract class BaseExportRunnable
implements Runnable {
    protected static final Joiner FILE_JOINER = Joiner.on((String)",").useForNull("");
    private final Long taskId = new Date().getTime();
    private File file;
    @Autowired
    private SsoExportFileService ssoExportFileService;
    private BoundHashOperations<String, String, String> ops;

    @PostConstruct
    public void init() {
        this.createFile();
        String key = this.ssoExportFileService.getTaskKey(this.taskId);
        StringRedisTemplate stringRedisTemplate = this.ssoExportFileService.getStringRedisTemplate();
        this.ops = stringRedisTemplate.boundHashOps((Object)key);
        this.ops.put((Object)"successCount", (Object)"0");
        this.ops.put((Object)"count", (Object)"0");
        this.ops.put((Object)"success", (Object)"false");
        this.ops.put((Object)"url", (Object)"");
        this.ops.put((Object)"fileName", (Object)this.file.getName());
        this.ops.put((Object)"taskId", (Object)this.taskId.toString());
    }

    @PreDestroy
    public void des() {
        if (this.file != null && this.file.exists()) {
            this.file.delete();
        }
    }

    public Long getTaskId() {
        return this.taskId;
    }

    protected File getTempFile() {
        return this.file;
    }

    protected void setIncrementCount(Integer count) {
        Objects.requireNonNull(count);
        this.ops.increment((Object)"successCount", (long)count.intValue());
    }

    protected void setCount(Integer count) {
        this.ops.put((Object)"count", (Object)count.toString());
    }

    protected void setMessage(String message) {
        this.ops.put((Object)"message", (Object)message);
    }

    protected void complete(String url) {
        this.ops.put((Object)"url", (Object)url);
        this.ops.put((Object)"success", (Object)"true");
    }

    protected void error(String message) {
        this.ops.put((Object)"message", (Object)message);
        this.ops.put((Object)"success", (Object)"true");
    }

    private void createFile() {
        File tempDir = this.ssoExportFileService.getTempDir();
        this.file = new File(tempDir, String.valueOf(new Date().getTime()) + ".csv");
    }

    protected String useForNull(Object obj) {
        StringBuilder builder = new StringBuilder();
        builder.append("\"");
        if (Objects.equals(null, obj)) {
            builder.append("");
        } else {
            builder.append(obj.toString());
        }
        builder.append("\"");
        return builder.toString();
    }

    protected abstract String getOssPath();
}

