/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.service.system;

import cn.com.duiba.sso.api.domain.dto.SystemDto;
import cn.com.duiba.sso.api.remoteservice.RemoteSystemService;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SsoSystemService {
    private Logger logger = LoggerFactory.getLogger(SsoSystemService.class);
    @Autowired
    private RemoteSystemService remoteSystemService;
    private LoadingCache<String, SystemDto> cache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, SystemDto>(){

        public SystemDto load(String systemAlias) {
            return SsoSystemService.this.remoteSystemService.getSystemByAlias(systemAlias);
        }
    });

    public SystemDto getSystemByAlias(String systemAlias) {
        try {
            return (SystemDto)this.cache.get((Object)systemAlias);
        }
        catch (Exception e) {
            this.logger.debug("", (Throwable)e);
            return null;
        }
    }
}

