/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.service.system;

import cn.com.duiba.sso.api.domain.dto.SystemDto;
import cn.com.duiba.sso.api.remoteservice.RemoteSystemService;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SsoSystemService {
    private static final String SSO_SERVER_NAME = "sso-service";
    private Logger logger = LoggerFactory.getLogger(SsoSystemService.class);
    @Autowired
    private RemoteSystemService remoteSystemService;
    private LoadingCache<String, SystemDto> cache = Caffeine.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build(systemName -> this.remoteSystemService.getSystemByAlias(systemName));

    public SystemDto getSystemByAlias(String systemAlias) {
        try {
            return (SystemDto)this.cache.get((Object)systemAlias);
        }
        catch (Exception e) {
            this.logger.debug("", (Throwable)e);
            return null;
        }
    }

    public String getSsoHomeUrl() {
        return this.getSystemByAlias(SSO_SERVER_NAME).getHomeUrl();
    }
}

